<?php
//  Validate postal address and obtain the latitude and longitude of the address
function valueToZero($val){
    return empty($val)?0:$val;
}

@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

require_once __DIR__ . '/../unirest_3.0.4/autoload.php'; 

$url_basic = 'https://maps.googleapis.com/maps/api/geocode/json';
$host = 'maps.googleapis.com';
$api_key = 'aaaaaaaaaaaaaaaaaaaaaaaaaaa'; // Your Api Key of Google MAP
$lang='es'; // For services of Google Map

$address = $values['address'];
$address = str_replace("\n", ',', $address);
$address = str_replace("\r", ' ', $address);
$address = htmlspecialchars($address);

$response = Unirest\Request::get("$url_basic?address=$address&language=$lang&key=$api_key",
  array()
	);
$a = $response->code;        // HTTP Status code
$b = $response->headers;     // Headers
$c = $response->body;        // Parsed body
$d = $response->raw_body;    // Unparsed body
$f = json_decode($d,true);
// var_dump($f); // DUMP pf array
$count = count($f["results"]);

foreach($f["results"] as $results) {
	$standardAddress = $results["formatted_address"];
	$latency = $results["geometry"]["location"]["lat"];
	$length = $results["geometry"]["location"]["lng"];
	$dir = array();
	foreach($results["address_components"] as $e) {
		$type = $e["types"][0];
		$dir[$type] = $e["long_name"];
		}
        $standardAddress2 = $dir["route"].', '.$dir["street_number"].' '.$dir["subpremise"]."\n".
                           $dir["postal_code"].' '. $dir["locality"]."\n".
                           $dir["administrative_area_level_2"]."\n".
                           $dir["administrative_area_level_1"]."\n".
                           $dir["country"];
	$values["standardAddress"] = $standardAddress2;
	$values["latency"] = $latency;
	$values["length"] = $length;
	break;
}
