<?php
//  Create ARRAY with the data Hierarchy
function convertToHierarchy($results, $idField='user_id', $parentIdField='Boss', $childrenField='') {
      $hierarchy = array(); // -- Stores the final data
      $itemReferences = array(); // -- temporary array, storing references to all items in a single-dimention
      foreach ( $results as $item ) {
            $id       = $item[$idField];
            $parentId = $item[$parentIdField];
            if (isset($itemReferences[$parentId])) { // parent exists
                  $itemReferences[$parentId][$childrenField][$id] = $item; // assign item to parent
                  $itemReferences[$id] =& $itemReferences[$parentId][$childrenField][$id]; // reference parent's item in single-dimentional array
            } elseif (!$parentId || !isset($hierarchy[$parentId])) { // -- parent Id empty or does not exist. Add it to the root
                  $hierarchy[$id] = $item;
                  $itemReferences[$id] =& $hierarchy[$id];
            }
      }
      unset($results, $item, $id, $parentId);
      // -- Run through the root one more time. If any child got added before it's parent, fix it.
      foreach ( $hierarchy as $id => &$item ) {
            $parentId = $item[$parentIdField];
            if ( isset($itemReferences[$parentId] ) ) { // -- parent DOES exist
                  $itemReferences[$parentId][$childrenField][$id] = $item; // -- assign it to the parent's list of children
                  unset($hierarchy[$id]); // -- remove it from the root of the hierarchy
            }
      }
      unset($itemReferences, $id, $item, $parentId);
      return $hierarchy;
}
function findUser($hierarchy, $id_user) {
        foreach ($hierarchy as $v) {
        if ($v['id_user'] == $id_user){ // Find the id of the connected user
            if (!empty($v['children'])) { // Recursive find
                return ($v);

            }
        }
        if (!empty($v['children'])) { // Recursive find
            findUser($v['children'], $id_user);
        }
    }
 return [];
}

function listChildrenUser($hierarchy,$list) {
    foreach ($hierarchy as $v) {
        $list .= $v['id_user'].',';
        if (!empty($v['children'])) { // Recursive find
            $list = listChildrenUser($v['children'], $list); 
        }     
    }
 return $list;
}

global $conn;

// Create auxiliary Sorting tables
$results = array();
$sql = "SELECT id_user , ifnull(Boss,'') id_parent, Name FROM hierarchy_users";
if ($resql = db_query($sql,$conn)) {
    /* obtener array asociativo */
    while ($row = db_fetch_array($resql)) {
        $results[] = $row;
    }
}
$Hierarchy = convertToHierarchy($results,'id_user','id_parent','children'); // Create hierarchy from data

$user = $_SESSION["id_user"] ; // id User connect
$Hierarchy2 = array();
$list = '';

$Hierarchy2[] = findUser($Hierarchy, $user); // Create List of dependent User id
$list = listChildrenUser($Hierarchy2,$list);

$_SESSION['user_dependence'] = substr($list, 0,strlen($list)-1); // Delete final ','

?>