<?php
include __DIR__.'/hierarchy.php';

$html = <<<EOT
<link rel="stylesheet" href="lib_orgchart/css/jquery.orgchart.css">
<style type="text/css">
#chart-container {
  position: relative;
  height: 520px;
  border: 1px solid #aaa;
  margin: 0.5rem;
  overflow: auto;
  text-align: center;
}
 .orgchart { background: #fff; }
 .orgchart .second-menu-icon {
	transition: opacity .5s;
	opacity: 0;
	right: -5px;
	top: -5px;
	z-index: 2;
	position: absolute;
 }
 .orgchart .second-menu-icon::before { background-color: rgba(68, 157, 68, 0.5); }
 .orgchart .second-menu-icon:hover::before { background-color: #449d44; }
 .orgchart .node:hover .second-menu-icon { opacity: 1; }
 .orgchart .node .second-menu {
	display: none;
	position: absolute;
	top: 0;
	right: -70px;
	border-radius: 35px;
	box-shadow: 0 0 10px 1px #999;
	background-color: #fff;
	z-index: 1;
 }
 .orgchart .node .second-menu .avatar {
	width: 60px;
	height: 60px;
	border-radius: 30px;
	float: left;
	margin: 5px;
 }
</style>

<div id="chart-container"></div>

<script type="text/javascript" src="lib_orgchart/js/jquery.orgchart.js"></script>
<script type="text/javascript">
\$(function() {
 console.log( "ready!" );

 var datascource = $datasource;

 \$('#chart-container').orgchart({
	'data' : datascource,
	'nodeId': 'id',
	'visibleLevel': 2,
	'nodeContent': 'title',
	'toggleSiblingsResp': true,
	'pan': true,
	'zoom': true,
	'zoominLimit': 7,
	'zoomoutLimit': 0.5,
	'chartClass': '',
	'exportButton': false,
	'exportButtonName': 'Export',
	'exportFilename': 'OrgChart',
	'exportFileextension': 'png',
	'parentNodeSymbol': 'oci-leader',
	'createNode': function(\$node, data) {
	  var secondMenuIcon = \$('<i>', {
		 'class': 'oci oci-info-circle second-menu-icon',
		 click: function() {
			$(this).siblings('.second-menu').toggle();
		 }
	  });
	  var secondMenu = '<div class="second-menu"><img class="avatar" src="'+ data.picture + '"></div>';
	  \$node.append(secondMenuIcon).append(secondMenu);
	}
 });

});
</script>

EOT;
echo $html;
