-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

-- -----------------------------------------------------
-- Schema vacaciones
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema vacaciones
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `vacaciones` DEFAULT CHARACTER SET utf8 ;
USE `vacaciones` ;

-- -----------------------------------------------------
-- Table `vacaciones`.`usuario`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `vacaciones`.`usuario` (
  `idusuario` INT NOT NULL AUTO_INCREMENT,
  `Login` VARCHAR(16) NOT NULL,
  `NombreyApellido` VARCHAR(100) NOT NULL,
  `Password` VARCHAR(100) NOT NULL,
  `Color` VARCHAR(10) NOT NULL DEFAULT '#000000',
  `UsuarioUltModificacion` VARCHAR(16) NOT NULL,
  `FechaUltModificacion` DATE NOT NULL,
  PRIMARY KEY (`idusuario`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_spanish_ci;


-- -----------------------------------------------------
-- Table `vacaciones`.`grupo_trabajo`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `vacaciones`.`grupo_trabajo` (
  `idgrupo_trabajo` INT NOT NULL AUTO_INCREMENT,
  `Titulo` VARCHAR(40) NOT NULL,
  `Descripcion` VARCHAR(300) NULL,
  `Color` VARCHAR(10) NOT NULL,
  PRIMARY KEY (`idgrupo_trabajo`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_spanish_ci;


-- -----------------------------------------------------
-- Table `vacaciones`.`periodo`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `vacaciones`.`periodo` (
  `idperiodo` INT NOT NULL AUTO_INCREMENT,
  `Titulo` VARCHAR(50) NOT NULL,
  `Descripcion` VARCHAR(300) NULL,
  `FechaInicio` DATE NOT NULL,
  `FechaFin` DATE NOT NULL,
  `Abierto` INT NOT NULL DEFAULT 0,
  PRIMARY KEY (`idperiodo`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_spanish_ci;


-- -----------------------------------------------------
-- Table `vacaciones`.`usuario_grupo`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `vacaciones`.`usuario_grupo` (
  `idusuario_grupo` INT NOT NULL AUTO_INCREMENT,
  `usuario_idusuario` INT NOT NULL,
  `grupo_trabajo_idgrupo_trabajo` INT NOT NULL,
  PRIMARY KEY (`idusuario_grupo`),
  INDEX `fk_usuario_grupo_usuario_idx` (`usuario_idusuario` ASC),
  INDEX `fk_usuario_grupo_grupo_trabajo1_idx` (`grupo_trabajo_idgrupo_trabajo` ASC),
  CONSTRAINT `fk_usuario_grupo_usuario`
    FOREIGN KEY (`usuario_idusuario`)
    REFERENCES `vacaciones`.`usuario` (`idusuario`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_usuario_grupo_grupo_trabajo1`
    FOREIGN KEY (`grupo_trabajo_idgrupo_trabajo`)
    REFERENCES `vacaciones`.`grupo_trabajo` (`idgrupo_trabajo`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_spanish_ci;


-- -----------------------------------------------------
-- Table `vacaciones`.`peticion`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `vacaciones`.`peticion` (
  `idpeticion` INT NOT NULL AUTO_INCREMENT,
  `usuario_idusuario` INT NOT NULL,
  `periodo_idperiodo` INT NOT NULL,
  `FechaInicio` DATE NOT NULL,
  `FechaFin` DATE NOT NULL,
  `DiasNaturales` INT NOT NULL,
  `DiasLaborables` INT NOT NULL,
  `DiasFinSemana` INT NOT NULL,
  `DiasFiesta` INT NOT NULL,
  PRIMARY KEY (`idpeticion`),
  INDEX `fk_peticion_usuario1_idx` (`usuario_idusuario` ASC),
  INDEX `fk_peticion_periodo1_idx` (`periodo_idperiodo` ASC),
  CONSTRAINT `fk_peticion_usuario1`
    FOREIGN KEY (`usuario_idusuario`)
    REFERENCES `vacaciones`.`usuario` (`idusuario`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_peticion_periodo1`
    FOREIGN KEY (`periodo_idperiodo`)
    REFERENCES `vacaciones`.`periodo` (`idperiodo`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_spanish_ci;


-- -----------------------------------------------------
-- Table `vacaciones`.`festivos`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `vacaciones`.`festivos` (
  `idfestivos` INT NOT NULL AUTO_INCREMENT,
  `DiaFiesta` DATE NOT NULL,
  `Titulo` VARCHAR(100) NULL,
  PRIMARY KEY (`idfestivos`),
  UNIQUE INDEX `DiaFiesta_UNIQUE` (`DiaFiesta` ASC))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8
COLLATE = utf8_spanish_ci;

USE `vacaciones` ;

-- -----------------------------------------------------
-- function workdaydiff
-- -----------------------------------------------------

DELIMITER $$
USE `vacaciones`$$
CREATE  FUNCTION `workdaydiff`(b date, a date) RETURNS int(11)
    DETERMINISTIC
    COMMENT 'working day difference for 2 dates'
BEGIN

DECLARE freedays int;
 
SET freedays = 0;
SET @x = DATEDIFF(b, a);
IF @x<0 THEN
SET @m = a;
SET a = b;
SET b = @m;
SET @m = -1;
ELSE
SET @m = 1;
END IF;
SET @x = abs(@x) + 1;

SET @w1 = WEEKDAY(a)+1;
SET @wx1 = 8-@w1;
IF @w1>5 THEN
SET @w1 = 0;
ELSE
SET @w1 = 6-@w1;
END IF;

SET @wx2 = WEEKDAY(b)+1;
SET @w2 = @wx2;
IF @w2>5 THEN
SET @w2 = 5;
END IF;
 
SET @weeks = (@x-@wx1-@wx2)/7;
SET @noweekends = (@weeks*5)+@w1+@w2;

SET @result = @noweekends-freedays;
RETURN @result*@m;
END$$

DELIMITER ;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
