<?php
// https://github.com/picqer/php-barcode-generator , source of Code

/* 
Occurs after record was updated  or added

$values     - array of values has been written to the database.
              To access specific field value use $values["FieldName"]
              "dict" is an alternate name for this parameter.              
$where      - WHERE clause that points to the edited record. Example: ID=19              
$oldvalues  - array with replaced field values. To access specific column value use
              $oldvalues["FieldName"]              
$keys       - array of key column values that point to the edited record. To access
              specific key column use $keys["KeyFieldName"]              
$inline     - equals to true when the Inline Edit in process, false otherwise              
$pageObject - an object of Page class representing the current page  
*/

// Load the barcode library classes
require_once __DIR__ . '/php-barcode-generator_2.0.1/autoload.php'; 

// Save it to a file
// $temp_file_png = tempnam(sys_get_temp_dir(), 'PNG');
// unlink($temp_file_png);  // delete file tmp

$Text = $key_barcode; // Number Invoice

$type = 'C39';
$Color = [0, 0, 0]; // Black
$generator = new Picqer\Barcode\BarcodeGeneratorPNG();
file_put_contents($temp_file_png, $generator->getBarcode($Text, $type, 2, 25, $Color));

/*
The getBarcode() method accepts the following parameters:

    $barcode  - String needed to encode in the barcode
    $type  - Type of barcode, use the constants defined in the class
    $widthFactor  - Width is based on the length of the data, with this factor you can make the barcode bars wider than default
    $height  - The total height of the barcode in pixels
    $foregroundColor -  Hex code as string, or array of RGB, of the colors of the bars (the foreground color)
*/

