<?php
// Item selected are delivered in session variable "item_select"
global $item_select;
$item_select = $_SESSION['item_select'];
$item_select = explode(",", $item_select);

//  Create ARRAY with the data Hierarchy
function convertToHierarchy($results, $idField='id', $parentIdField='Boss', $childrenField='') {
      $hierarchy = array(); // -- Stores the final data
      $itemReferences = array(); // -- temporary array, storing references to all items in a single-dimention
      foreach ( $results as $item ) {
            $id       = $item[$idField];
            $parentId = $item[$parentIdField];
            if (isset($itemReferences[$parentId])) { // parent exists
                  $itemReferences[$parentId][$childrenField][$id] = $item; // assign item to parent
                  $itemReferences[$id] =& $itemReferences[$parentId][$childrenField][$id]; // reference parent's item in single-dimentional array
            } elseif (!$parentId || !isset($hierarchy[$parentId])) { // -- parent Id empty or does not exist. Add it to the root
                  $hierarchy[$id] = $item;
                  $itemReferences[$id] =& $hierarchy[$id];
            }
      }
      unset($results, $item, $id, $parentId);
      // -- Run through the root one more time. If any child got added before it's parent, fix it.
      foreach ( $hierarchy as $id => &$item ) {
            $parentId = $item[$parentIdField];
            if ( isset($itemReferences[$parentId] ) ) { // -- parent DOES exist
                  $itemReferences[$parentId][$childrenField][$id] = $item; // -- assign it to the parent's list of children
                  unset($hierarchy[$id]); // -- remove it from the root of the hierarchy
            }
      }
      unset($itemReferences, $id, $item, $parentId);
      return $hierarchy;
} // 

function identation($level) {
    $identation ='';
    for ($i = 1;$i < $level; $i++) {
        $identation .= "\t";
    }
    return $identation;
}
// Print data of record 
function printRow($level, $row) {
    global $datasource;
   // {  "code": null,"name": "Economy car","nodeExpanded": false, "nodeSelected": true,"attributes": {"data-id": "1"},
		$nodeSelect = '';
		global $item_select;
		if (in_array($row['id_tree'], $item_select)) {
				$nodeSelect = " 'nodeSelected': true ,";
		}

    $datasource .= identation($level)."{ 'code': '".addslashes($row['code'])."', 'name': '".addslashes($row['name'])
										."', 'nodeExpanded': ".$_SESSION['nodeExpanded'].", ".$nodeSelect."'attributes': {'data-id': '".$row['id_tree']."'} ";
};
function printHierarchy ($level, $Hierarchy) {
    global $datasource;

    do {
        $key = key($Hierarchy);
        $value = current($Hierarchy);
        printRow($level+1, $value);
         if ( is_array($value['children'])){
             $datasource .= ",\n".identation($level+1)." 'children': [ \n";
             printHierarchy ($level+1, $value['children']);  // Recursive
             $datasource .= "\n".identation($level+1)."  ]";
					} else {
							$datasource .= ", 'children': null ";
					}
        $datasource .= "},\n";     
    } while (next($Hierarchy));
    $datasource = substr($datasource, 0, -2); // Delete last ","
}

global $conn;
// Create auxiliary Sorting tables
$results = array();
$sql = "SELECT id_tree_keys, code, name, ifnull(parent_id,'') parent_id FROM tree_keys order by code asc";
$resql = DB::Query($sql); 
    /* get associative array */
while ($row = $resql->fetchAssoc()) {
	$results[] = ['id_tree' =>$row['id_tree_keys'],'id_parent' =>$row['parent_id'],'name' =>$row['name'], 'code' =>$row['code']];

 }
$Hierarchy = convertToHierarchy($results,'id_tree','id_parent','children'); // Create hierarchy from data

unset($results); // Delete variable
$level = 0;

$datasource = '';
global $datasource;

if ( count($Hierarchy) <> 0 ) {
    printHierarchy ($level, $Hierarchy); 
}
$datasource = '['.$datasource.']';
unset($Hierarchy);

?>