<?php 
/*
library  https://github.com/clegginabox/pdf-merger

Exmple:
$pdf = new \Clegginabox\PDFMerger\PDFMerger;

$pdf->addPDF('samplepdfs/one.pdf', '1, 3, 4');
$pdf->addPDF('samplepdfs/two.pdf', '1-2');
$pdf->addPDF('samplepdfs/three.pdf', 'all');

//You can optionally specify a different orientation for each PDF
$pdf->addPDF('samplepdfs/one.pdf', '1, 3, 4', 'L');
$pdf->addPDF('samplepdfs/two.pdf', '1-2', 'P');

$pdf->merge('file', 'samplepdfs/TEST2.pdf', 'P');

// REPLACE 'file' WITH 'browser', 'download', 'string', or 'file' for output options
// Last parameter is for orientation (P for protrait, L for Landscape). 
// This will be used for every PDF that doesn't have an orientation specified
*/
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

require_once(__DIR__ . "/../include/dbcommon.php");
require_once(__DIR__ . "/analysis_of_files.php");

require_once __DIR__ . '/pdfMerge_1.0/autoload.php';

$rs = DB::Query("select * from pdfmerge where id_pdfMerge =".$_SESSION['id_pdfMerge']);
while( $data = $rs->fetchAssoc() )
{
    $arrayFiles = arrayPDF($data['Files']);
    $arrayCommand = explode("\n", $data['Command']);

    $pdf = new \Clegginabox\PDFMerger\PDFMerger;
    foreach ($arrayCommand as &$Command) {
        $statement = explode(";",$Command);
        if ( count($statement) > 1 ) {
            $part1 = explode(")",$statement[0]);
            $part2 = explode("(",$part1[0]);
            $file =  $part2[1];
            if ( is_numeric($file) ) {
                $part = explode("|",$statement[1]);
                switch (count($part)) {
                 case 1:
                          $pdf->addPDF($arrayFiles[$file], trim($part[0]));
                          break;
                 case 2:
                          $pdf->addPDF($arrayFiles[$file], trim($part[0]), trim($part[1]));
                          break;
                }
            } else {
                $part = explode(" | ",$statement[1]);
                switch (count($part)) {
                 case 2:
                          $pdf->merge(trim($part[0]), trim($part[1]));
                          break;
                 case 3:
                          $pdf->merge(trim($part[0]), trim($part[1]), trim($part[2]) );
                          break;
                }							
            }
        }
    }

}