
import videojs from'video.js';var validSeconds=function validSeconds(s){return typeof s==='number'&&!isNaN(s)&&s>=0&&s<Infinity;};var reset=function reset(player){var aa=player.playlist.autoadvance_;if(aa.timeout){player.clearTimeout(aa.timeout);}
if(aa.trigger){player.off('ended',aa.trigger);}
aa.timeout=null;aa.trigger=null;};var setup=function setup(player,delay){reset(player);if(!validSeconds(delay)){player.playlist.autoadvance_.delay=null;return;}
player.playlist.autoadvance_.delay=delay;player.playlist.autoadvance_.trigger=function(){var cancelOnPlay=function cancelOnPlay(){return setup(player,delay);};player.one('play',cancelOnPlay);player.playlist.autoadvance_.timeout=player.setTimeout(function(){reset(player);player.off('play',cancelOnPlay);player.playlist.next();},delay*1000);};player.one('ended',player.playlist.autoadvance_.trigger);};var clearTracks=function clearTracks(player){var tracks=player.remoteTextTracks();var i=tracks&&tracks.length||0;while(i--){player.removeRemoteTextTrack(tracks[i]);}};var playItem=function playItem(player,item){var replay=!player.paused()||player.ended();player.trigger('beforeplaylistitem',item.originalValue||item);if(item.playlistItemId_){player.playlist.currentPlaylistItemId_=item.playlistItemId_;}
player.poster(item.poster||'');player.src(item.sources);clearTracks(player);player.ready(function(){(item.textTracks||[]).forEach(player.addRemoteTextTrack.bind(player));player.trigger('playlistitem',item.originalValue||item);if(replay){var playPromise=player.play();if(typeof playPromise!=='undefined'&&typeof playPromise.then==='function'){playPromise.then(null,function(e){});}}
setup(player,player.playlist.autoadvance_.delay);});return player;};var isItemObject=function isItemObject(value){return!!value&&typeof value==='object';};var transformPrimitiveItems=function transformPrimitiveItems(arr){var list=[];var tempItem;arr.forEach(function(item){if(!isItemObject(item)){tempItem=Object(item);tempItem.originalValue=item;}else{tempItem=item;}
list.push(tempItem);});return list;};var generatePlaylistItemId=function generatePlaylistItemId(arr){var guid=1;arr.forEach(function(item){item.playlistItemId_=guid++;});};var indexInPlaylistItemIds=function indexInPlaylistItemIds(list,currentItemId){for(var i=0;i<list.length;i++){if(list[i].playlistItemId_===currentItemId){return i;}}
return-1;};var sourceEquals=function sourceEquals(source1,source2){var src1=source1;var src2=source2;if(typeof source1==='object'){src1=source1.src;}
if(typeof source2==='object'){src2=source2.src;}
if(/^\/\//.test(src1)){src2=src2.slice(src2.indexOf('//'));}
if(/^\/\//.test(src2)){src1=src1.slice(src1.indexOf('//'));}
return src1===src2;};var indexInSources=function indexInSources(arr,src){for(var i=0;i<arr.length;i++){var sources=arr[i].sources;if(Array.isArray(sources)){for(var j=0;j<sources.length;j++){var source=sources[j];if(source&&sourceEquals(source,src)){return i;}}}}
return-1;};var randomize=function randomize(arr){var index=-1;var lastIndex=arr.length-1;while(++index<arr.length){var rand=index+Math.floor(Math.random()*(lastIndex-index+1));var value=arr[rand];arr[rand]=arr[index];arr[index]=value;}
return arr;};function factory(player,initialList,initialIndex){if(initialIndex===void 0){initialIndex=0;}
var list=null;var changing=false;var playlist=player.playlist=function(newList,newIndex){if(newIndex===void 0){newIndex=0;}
if(changing){throw new Error('do not call playlist() during a playlist change');}
if(Array.isArray(newList)){var previousPlaylist=Array.isArray(list)?list.slice():null;var nextPlaylist=newList.slice();list=nextPlaylist.slice();if(list.filter(function(item){return isItemObject(item);}).length!==list.length){list=transformPrimitiveItems(list);}
generatePlaylistItemId(list);changing=true;player.trigger({type:'duringplaylistchange',nextIndex:newIndex,nextPlaylist:nextPlaylist,previousIndex:playlist.currentIndex_,previousPlaylist:previousPlaylist||[]});changing=false;if(newIndex!==-1){playlist.currentItem(newIndex);}
if(previousPlaylist){player.setTimeout(function(){player.trigger('playlistchange');},0);}}
return list.map(function(item){return item.originalValue||item;}).slice();};player.on('loadstart',function(){if(playlist.currentItem()===-1){reset(player);}});playlist.currentIndex_=-1;playlist.player_=player;playlist.autoadvance_={};playlist.repeat_=false;playlist.currentPlaylistItemId_=null;playlist.currentItem=function(index){if(changing){return playlist.currentIndex_;}
if(typeof index==='number'&&playlist.currentIndex_!==index&&index>=0&&index<list.length){playlist.currentIndex_=index;playItem(playlist.player_,list[playlist.currentIndex_]);return playlist.currentIndex_;}
var src=playlist.player_.currentSrc()||'';if(playlist.currentPlaylistItemId_){var indexInItemIds=indexInPlaylistItemIds(list,playlist.currentPlaylistItemId_);var item=list[indexInItemIds];if(item&&Array.isArray(item.sources)&&indexInSources([item],src)>-1){playlist.currentIndex_=indexInItemIds;return playlist.currentIndex_;}
playlist.currentPlaylistItemId_=null;}
playlist.currentIndex_=playlist.indexOf(src);return playlist.currentIndex_;};playlist.contains=function(value){return playlist.indexOf(value)!==-1;};playlist.indexOf=function(value){if(typeof value==='string'){return indexInSources(list,value);}
var sources=Array.isArray(value)?value:value.sources;for(var i=0;i<sources.length;i++){var source=sources[i];if(typeof source==='string'){return indexInSources(list,source);}else if(source.src){return indexInSources(list,source.src);}}
return-1;};playlist.currentIndex=function(){return playlist.currentItem();};playlist.lastIndex=function(){return list.length-1;};playlist.nextIndex=function(){var current=playlist.currentItem();if(current===-1){return-1;}
var lastIndex=playlist.lastIndex();if(playlist.repeat_&&current===lastIndex){return 0;}
return Math.min(current+1,lastIndex);};playlist.previousIndex=function(){var current=playlist.currentItem();if(current===-1){return-1;}
if(playlist.repeat_&&current===0){return playlist.lastIndex();}
return Math.max(current-1,0);};playlist.first=function(){if(changing){return;}
var newItem=playlist.currentItem(0);if(list.length){return list[newItem].originalValue||list[newItem];}
playlist.currentIndex_=-1;};playlist.last=function(){if(changing){return;}
var newItem=playlist.currentItem(playlist.lastIndex());if(list.length){return list[newItem].originalValue||list[newItem];}
playlist.currentIndex_=-1;};playlist.next=function(){if(changing){return;}
var index=playlist.nextIndex();if(index!==playlist.currentIndex_){var newItem=playlist.currentItem(index);return list[newItem].originalValue||list[newItem];}};playlist.previous=function(){if(changing){return;}
var index=playlist.previousIndex();if(index!==playlist.currentIndex_){var newItem=playlist.currentItem(index);return list[newItem].originalValue||list[newItem];}};playlist.autoadvance=function(delay){setup(playlist.player_,delay);};playlist.repeat=function(val){if(val===undefined){return playlist.repeat_;}
if(typeof val!=='boolean'){videojs.log.error('videojs-playlist: Invalid value for repeat',val);return;}
playlist.repeat_=!!val;return playlist.repeat_;};playlist.sort=function(compare){if(!list.length){return;}
list.sort(compare);if(changing){return;}
player.trigger('playlistsorted');};playlist.reverse=function(){if(!list.length){return;}
list.reverse();if(changing){return;}
player.trigger('playlistsorted');};playlist.shuffle=function(_temp){var _ref=_temp===void 0?{}:_temp,rest=_ref.rest;var index=0;var arr=list;if(rest){index=playlist.currentIndex_+1;arr=list.slice(index);}
if(arr.length<=1){return;}
randomize(arr);if(rest){var _list;(_list=list).splice.apply(_list,[index,arr.length].concat(arr));}
if(changing){return;}
player.trigger('playlistsorted');};if(Array.isArray(initialList)){playlist(initialList.slice(),initialIndex);}else{list=[];}
return playlist;}
var version="4.3.1";var registerPlugin=videojs.registerPlugin||videojs.plugin;var plugin=function plugin(list,item){factory(this,list,item);};registerPlugin('playlist',plugin);plugin.VERSION=version;export default plugin;