<?php
// https://github.com/ihabunek/pdf417-php,           source of Code

/* 
Occurs after record was updated  or added

$values     - array of values has been written to the database.
              To access specific field value use $values["FieldName"]
              "dict" is an alternate name for this parameter.              
$where      - WHERE clause that points to the edited record. Example: ID=19              
$oldvalues  - array with replaced field values. To access specific column value use
              $oldvalues["FieldName"]              
$keys       - array of key column values that point to the edited record. To access
              specific key column use $keys["KeyFieldName"]              
$inline     - equals to true when the Inline Edit in process, false otherwise              
$pageObject - an object of Page class representing the current page  
*/

// Load the PDF417 library classes
require_once __DIR__ . '/pdf417_0.3/autoload.php'; 

use BigFish\PDF417\PDF417;
use BigFish\PDF417\Renderers\ImageRenderer;
// use BigFish\PDF417\Renderers\SvgRenderer;

// Create a basic PDF417 code
$pdf417 = new PDF417();
$pdf417->setColumns(20); // Muy importante para campos de gran tamaño. Máximo 30
$pdf417->setSecurityLevel(5); // Muy importante fijar nivel de seguridad de código. Máximo 8

$data = $pdf417->encode($values['Text']); 

// Set advanced options
$renderer = new ImageRenderer([
	'format' => 'png',
	'color' => '#000000',
	'bgColor' => '#FFFFFF',
	'scale' => 5,
]);

$image = $renderer->render($data);

// Save it to a file
$fileName = 'PDF417_'.$values['id'].'.png';
$file = substr(__DIR__, 0, -6);  // root of file
$file = $file.'files/'.$fileName;
$image->save($file);

// Save the new file in Database
$size = filesize($file);
$fileArray = [];
$fileArray[0][name]= 'files\/'.$fileName;
$fileArray[0][usrName]= $fileName;
$fileArray[0][size]= $size;
$fileArray[0][type]= 'image\/png';
$fileArray[0][searchStr] = $fileName.',!:sStrEnd'; 
$fileFileSystem=my_json_encode($fileArray);
						
// Update in DB the file
$id_key = $values['id']; 
$sql="Update prueba_pdf417 set File = '$fileFileSystem' where id = $id_key";
$res=db_exec($sql,$conn);

?>