<?php

  /**
     * Example: Get and parse all unseen emails with saving their attachments one by one.
     *
     * @author Sebastian Krätzig <info@ts3-tools.info>
     */
// Execution form CRON
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

require_once __DIR__.'/../include/dbcommon.php';     

//  Load Config of Application
global $conn;
$sql="SELECT `name` , value FROM config";
$resql=db_query($sql,$conn);
$data=$resql->fetch_all(MYSQLI_ASSOC);;
$_SESSION['config'] = $data; 
// CRON   
    //global $conn;
    
    require_once __DIR__.'/../php-imap_4.1.0/autoload.php';

    use PhpImap\Exceptions\ConnectionException;
    use PhpImap\Mailbox;

    // Load variables of Config
    $serverMail 	= $_SESSION['config'][array_search('GMAIL_server', array_column($_SESSION['config'], 'name'))][value];
    $login 		= $_SESSION['config'][array_search('GMAIL_Username', array_column($_SESSION['config'], 'name'))][value];
    $password 		= $_SESSION['config'][array_search('GMAIL_Password', array_column($_SESSION['config'], 'name'))][value];

    $buzonArchivo 	= $_SESSION['config'][array_search('ARCHIVE_Mailbox', array_column($_SESSION['config'], 'name'))][value];
    $directoryAttachments = $_SESSION['config'][array_search('FOLDER_FILES', array_column($_SESSION['config'], 'name'))][value];
    
    $dateEmail = '' ;
    $from_name = '';
    $from_email = '';
    $to = '';
    $subject = '';
    $message = '';
    
    $message_id = '';
    $num_message = 0;
    
    $mailbox = new Mailbox(
        $serverMail, // IMAP server and mailbox folder
        $login, // Username for the before configured mailbox
        $password // Password for the before configured username
    );

    try {
        $mail_ids = $mailbox->searchMailbox('UNSEEN');
    } catch (ConnectionException $ex) {
        die('IMAP connection failed: '.$ex->getMessage());
    } catch (Exception $ex) {
        die('An error occured: '.$ex->getMessage());
    }

  
    foreach ($mail_ids as $mail_id) {

        $email = $mailbox->getMail(
            $mail_id, // ID of the email, you want to get
            true // Do NOT mark emails as seen (optional)
        );

        $from_name = (isset($email->fromName) ? $email->fromName : $email->fromAddress);
        $from_email = $email->fromAddress;
        $to = $email->toString;
        $subject = $email->subject; 
        $message_id = $email->messageId;
        $dateEmail = date("Y-m-d H:i:s", strtotime($email->date));


        // Save attachments one by one
        if (!$mailbox->getAttachmentsIgnore()) {
            $attachments = $email->getAttachments();
            
            $num_attachment = 0;
						 $fileAttachment = [];

            foreach ($attachments as $attachment) {
                $usrName = $attachment->name;
								 $extension = $attachment->subtype;

                $name = $directoryAttachments.'/'.time().'_'.str_replace(' ', '_', $usrName); 
                $pathFile = substr(__DIR__, 0, -4).'/'.$name;
                $attachment->setFilePath($pathFile);

                if ($attachment->saveToDisk()) {
                    // echo "OK, saved!\n";
                } else {
                    // echo "ERROR, could not save!\n";
                }
                $size = filesize($pathFile);
                
                // Mime Type
                $sql = "SELECT MimeType FROM mime_type where Extension = lower('$extension')";
                $rs = $conn->query($sql);
                if ($data = $rs->fetch_assoc()) {
                    $type = $data[MimeType];
                    } else {
                    $type = 'application/octet-stream';
                };
                
                $fileAttachment[$num_attachment][name]= $name;
                $fileAttachment[$num_attachment][usrName]= $usrName;
                $fileAttachment[$num_attachment][size]= $size;
                $fileAttachment[$num_attachment][type]= $type;
                $fileAttachment[$num_attachment][searchStr] = $usrName.',!:sStrEnd'; 
                
                $num_attachment = $num_attachment + 1;                               
            }
        }

        if ($email->textHtml) {
            $message = $email->textHtml;
        } else {
            $message = $email->textPlain;
        }

        if (!empty($email->autoSubmitted)) {
            // Mark email as "read" / "seen"
            $mailbox->markMailAsRead($mail_id);
        }

        if (!empty($email_content->precedence)) {
            // Mark email as "read" / "seen"
            $mailbox->markMailAsRead($mail_id);
        }       
        
        $mailbox->moveMail($mail_id,$buzonArchivo); 
        
        $sql = "insert INTO  email (FromEmail, FromName, toEmail, Date, Subject, Message, Attachment) values
        (?,?,?,?,?,?,?)";
				 $rs = $conn->prepare($sql);
				 $rs->bind_param('sssssss', $from_email, $from_name, $to, $dateEmail, $subject, $message, $attachment);
				 $attachment = my_json_encode($fileAttachment);

				 // $subject = addslashes($conn->real_escape_string($subject));
				 // $message = addslashes($conn->real_escape_string($message));

				 $rs->execute();

        $num_message = $num_message + 1;
    }

    $mailbox->disconnect();
    


