<?php
use JasperPHP\Report;
use JasperPHP\ado\TTransaction;
use JasperPHP\ado\TLogger;
use JasperPHP\ado\TLoggerHTML;

//use \NumberFormatter;
//use PHPexcel as PHPexcel; // experimental
/**
 * classe TJasper
 *
 * @author   Rogerio Muniz de Castro <rogerio@quilhasoft.com.br>
 * @version  2018.10.15
 * @access   restrict
 * 
 * 2015.03.11 -- create
 * 2018.10.15 -- revision and internationalize, add TLogger classes
 * */
class TJasper {

    private $report;
    private $type;
    private $param;

    /**
     * method __construct()
     * 
     * @param $jrxml = a jrxml file name
     * @param $param = a array with params to use into jrxml report
     */
    public function __construct($jrxml, array $param) {
        $GLOBALS['reports'] = array();
        $xmlFile = $jrxml;
        $this->type = (array_key_exists('type', $param)) ? $param['type'] : 'pdf';
        $this->param = $param;
        $this->report = new JasperPHP\Report($xmlFile, $param); // $GLOBALS['reports'][$xmlFile];
        JasperPHP\Instructions::prepare($this->report);
    }

    public function outpage($filename = 'report.pdf') {
        $this->report->generate();
        $this->report->out();
        $pdf = JasperPHP\Instructions::get();
        $pdf->Output($filename, "I");           // Name of file of PDF       
    }

    public function setVariable($name, $value) {
        $this->report->arrayVariable[$name]['initialValue'] = $value;
    }
}

$param = array();                 // Parameter
$param["P_records"]= '001,002';

require('jasperPHP_20211007/autoload.php');

// $report_name = 'tabla.jrxml';  // File of Report
$report_name = 'provincias_sub.jrxml';  // File of Report

TTransaction::open('jasperDatabase/'.'report.ini');  		// DataBase of Report

TTransaction::setLogger(new TLoggerHTML('log.html')); // DEBUG

// Config TJasper
JasperPHP\Report::$proccessintructionsTime = 'inline'; // if uncomented this line intructions are proccessed after each database row
JasperPHP\Report::$defaultFolder = 'app.jrxml/MyReports';
JasperPHP\Report::$locale = 'es_es'; // Default "en_us"
JasperPHP\Report::$dec_point = ',';
JasperPHP\Report::$thousands_sep = '.';
JasperPHP\Report::$columnHeaderRepeat = true;

$jasper = new TJasper($report_name,$param);

$filename = "report.pdf";
$jasper->outpage($filename);
?>