<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");

use JasperPHP\Report;
use JasperPHP\ado\TTransaction;
use JasperPHP\ado\TLogger;
use JasperPHP\ado\TLoggerHTML;

class TJasper {
 private $report;
 private $type;
 private $param;

 public function __construct($jrxml, array $param) {
	  $GLOBALS['reports'] = array();
	  $xmlFile = $jrxml;
	  $this->type = (array_key_exists('type', $param)) ? $param['type'] : 'pdf';
	  $this->param = $param;
	  $this->report = new JasperPHP\Report($xmlFile, $param); // $GLOBALS['reports'][$xmlFile];
	  JasperPHP\Instructions::prepare($this->report);
 }

 public function outpage($filename = 'report.pdf') {
	  $this->report->generate();
	  $this->report->out();
	  $pdf = JasperPHP\Instructions::get();
	  $pdf->Output($filename, "I");           // Name of file of PDF       
 }

 public function setVariable($name, $value) {
	  $this->report->arrayVariable[$name]['initialValue'] = $value;
 }
}

$param = array();                 // Parameter
//  $param["P1"]= 1;

require('../jasperPHP_20211007/autoload.php');

$report_name = 'paises.jrxml';  // File of Report

TTransaction::open('../jasperDatabase/'.'report.txt');  		// DataBase of Report

// TTransaction::setLogger(new TLoggerHTML('log.html')); // DEBUG

// Config TJasper
JasperPHP\Report::$proccessintructionsTime = 'inline'; // if uncomented this line intructions are proccessed after each database row
JasperPHP\Report::$defaultFolder = '../app.jrxml';
JasperPHP\Report::$locale = 'es_es'; // Default "en_us"
JasperPHP\Report::$dec_point = ',';
JasperPHP\Report::$thousands_sep = '.';
JasperPHP\Report::$columnHeaderRepeat = true;

$jasper = new TJasper($report_name,$param);

$filename = "Paises.pdf";
$jasper->outpage($filename);
?>
