<?php
$html .= <<<EOT
<script src="https://unpkg.com/knockout@3.5.1/build/output/knockout-latest.js"></script> 
<script src="https://unpkg.com/survey-knockout@1.9.1/survey.ko.min.js"></script>
<script src="https://unpkg.com/surveyjs-widgets@1.9.1/surveyjs-widgets.min.js"></script>
<script src="https://unpkg.com/inputmask@5.0.3/dist/inputmask.js"></script>
<!-- HTML to PDF-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

<button style="margin:10px" class="btn btn-primary survey-print" onclick="saveToPdf()">Save to PDF</button>
<div>$welcome</div>
<div id="surveyElement"></div>
<div id="surveyResult"></div>
<div id="toVisible" style="display: none; width: 595px">
  <div id="toExport">
    <div>$welcome
      <div id="surveyPdfElement"></div>
    </div>
  </div>
</div>
<script>
function saveToPdf() {
    var hidden = document.getElementById('toVisible');
    hidden.style.display = 'block';
    surveyPdf = survey;
    surveyPdf.mode = 'display';
    surveyPdf.isSinglePage= true;
    surveyPdf.onAfterRenderSurvey.add((survey, options) => {
      var opt = {
        margin: [18, 10, 18, 10],
        filename: 'survey_$id_response.pdf',
        // this option avoid breaking the survey on an element
        pagebreak: { mode: 'avoid-all' }
      };
      var data = document.getElementById('toExport');
      html2pdf().set(opt).from(data).toPdf().get('pdf').then((pdfObject) => {
        // you can add headers or footers here... 
      }).save();
      
      hidden.style.display = 'none';
      
    });
    // $("#surveyPdfElement").Survey({ model: surveyPdf }); // OLD version
    surveyPdf.render("surveyPdfElement");
}

Survey
    .StylesManager
    .applyTheme("bootstrap");
Survey.defaultBootstrapCss.navigationButton = "btn btn-primary";


EOT;
?>