<?php

function getFutureBusinessDayWeek($num_business_days, $today_ymd = null, $holiday_dates_ymd = []) {
    $num_business_days = min($num_business_days, 1000);
    $business_day_count = 0;
    $current_timestamp = empty($today_ymd) ? time() : strtotime($today_ymd);
    while ($business_day_count < $num_business_days) {
        $next1WD = strtotime('+1 weekday', $current_timestamp);
        $next1WDDate = date('Y-m-d', $next1WD);        
        if (!in_array($next1WDDate, $holiday_dates_ymd)) {
            $business_day_count++;
        }
        $current_timestamp = $next1WD;
    }
    return date('Y-m-d', $current_timestamp);
}
function getFutureBusinessDay($num_business_days, $today_ymd = null, $holiday_dates_ymd = []) {
    $num_business_days = min($num_business_days, 1000);
    $business_day_count = 0;
    $current_timestamp = empty($today_ymd) ? time() : strtotime($today_ymd);
    while ($business_day_count < $num_business_days) {
        $next1WD = strtotime('+1 day', $current_timestamp);
        $next1WDDate = date('Y-m-d', $next1WD);        
        if (!in_array($next1WDDate, $holiday_dates_ymd)) {
            $business_day_count++;
        }
        $current_timestamp = $next1WD;
    }
    return date('Y-m-d', $current_timestamp);
}
//  Load Holiday of App
$holidays = [];
$rs = DB::Query("select holiday FROM holidays order by holiday"); 
while( $data = $rs->fetchAssoc() )
	{
		$holidays[] = $data['holiday'];
	}
$_SESSION['holidays'] = $holidays;

?>