<?php
require_once("include/dbcommon.php"); // DataBase PHPRunner

// Require our Event class and datetime utilities
require 'fullcalendar/php/utils.php';

// Short-circuit if the client did not give us a date range.
if (!isset($_GET['start']) || !isset($_GET['end'])) {
  die("Please provide a date range.");
}

// Parse the start/end parameters.
// These are assumed to be ISO8601 strings with no time nor timeZone, like "2013-12-29".
// Since no timeZone will be present, they will parsed as UTC.
$range_start = parseDateTime($_GET['start']);
$range_end = parseDateTime($_GET['end']);

// Parse the timeZone parameter if it is present.

$time_zone ='UTC';
if (isset($_GET['timeZone'])) {
//   $time_zone = new DateTimeZone($_GET['timeZone']);
}


$start = substr($_GET['start'],0,10).' 00:00:00'; 
$end   = substr($_GET['end']  ,0,10).' 00:00:00';
$now   = date('Y-m-d H:i:s', strtotime(now(). ' +2 hour')); // now() + 1
if ( $start < $now ) { //  Minimum date of the moment
//		$start = $now;
		}
$language = $_SESSION['language'];
$search = '';
If ( isset($_SESSION['q_IN']) && $_SESSION['q_IN'] <> '' ) {  // Are you coming from Room Search?
	$search = ' and bookings.rooms_idrooms IN ('.$_SESSION['q_IN'].') ';
}

$sql = "
SELECT idbookings, rooms_idrooms, fromDate, toDate,  name, phone, code
FROM bookings
join client on (client_idclient = idclient )
join rooms on (rooms_idrooms = idrooms )
where toDate >= '$start' and fromDate <= '$end' $search;
";
$resql = db_query($sql,$conn);
// Accumulate an output array of event data arrays.
$output_arrays = array();

while ($data = db_fetch_array($resql)){
$output_arrays[] = array(
    'id'=>$data['idbookings'],
    'title'=>$data['name'],
    'resourceId'=>$data['code'],
    'start'=>$data['fromDate'],
    'end'=>date('Y-m-d', strtotime($data['toDate']. ' +1 day')),
    'description'=>$data['phone']);
    }


// Send JSON to the client.
// $str = json_encode($output_arrays);
echo json_encode($output_arrays);

?>