<?php
global $conn;

$language = $hours_a_day = $_SESSION['config'][array_search('CALENDAR_LANGUAGE', array_column($_SESSION['config'], 'name'))]['value'];
$firstDay = $hours_a_day = $_SESSION['config'][array_search('CALENDAR_FIRST_DAY', array_column($_SESSION['config'], 'name'))]['value']; // 1 = Lunes, 0=Domingo

$now = substr(now(),0,10);
if (isset($_SESSION['q_fromDate'])) { $now = substr($_SESSION['q_fromDate'],0,10); }

$str1 = <<<EOD
 <style>
    html, body {
      margin: 0;
      padding: 0;
      font-family: Arial, Helvetica Neue, Helvetica, sans-serif;
      font-size: 12px; 
    }
    #calendar {
      max-width: 900px;
      max-height: 400px;
      margin: 40px auto;
    }
  </style>


<link href='fullcalendar/packages/core/main.css' rel='stylesheet' />
<link href='fullcalendar/packages-premium/timeline/main.css' rel='stylesheet' />
<link href='fullcalendar/packages-premium/resource-timeline/main.css' rel='stylesheet' />
<script src='fullcalendar/packages/core/main.js'></script>
<script src='fullcalendar/packages/interaction/main.js'></script>
<script src='fullcalendar/packages-premium/timeline/main.js'></script>
<script src='fullcalendar/packages-premium/resource-common/main.js'></script>
<script src='fullcalendar/packages-premium/resource-timeline/main.js'></script>

<script src='fullcalendar/packages/core/locales-all.js'></script>
<script src='fullcalendar/tooltip/tooltip.min.js'></script>

<script>
  var initialLocaleCode = '$language';
	var firstDay = '$firstDay'; 
  
  document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
      plugins: [ 'interaction', 'resourceTimeline' ],
      now: '$now',
      
      // timeZone: 'UTC+1', // the default 'local' (unnecessary to specify)
      locale: initialLocaleCode,
      
      editable: false,
      aspectRatio: 1.8,
      scrollTime: '00:00',
      header: {
        left: 'today prev,next',
        center: 'title',
        right: 'resourceTimelineMonth,resourceTimelineYear'
      },
      defaultView: 'resourceTimelineMonth',
      navLinks: true,
      resourceAreaWidth: '25%',
      resourceLabelText: 'Rooms',
      //
      eventClick: function(info) {
				var booking = info.event.id;
				var title = info.event.title;
				var url = "bookings_view.php?editid1="+booking;
				var header = '<h2 data-itemtype="view_header" data-itemid="view_header" data-pageid="10">'+'Booking: '+ title+'</h2>' ;
				window.popup = Runner.displayPopup({
                    url: url,
                    width: 800,
                    height: 500,
                    header: header
		   }); 
			},
			//
      resourceLabelText: 'Rooms',
      resources: { // you can also specify a plain string like 'json/resources.json'
        url: 'timeline_ajax_resource.php'},

      events: { // you can also specify a plain string like 'json/events-for-resources.json'
        url: 'timeline_ajax_event.php'},
    });

    calendar.render();
  });

</script>
  <div id='calendar'></div>

EOD;

echo $str1;


?>