$(() => {

    const pivotGridChart = $('#pivotgrid-chart').dxChart({
      commonSeriesSettings: {
        type: 'line',
      },
      tooltip: {
        enabled: true,
        format: {type: "currency", currency: "EUR", precision: 0 },
        customizeTooltip(args) {
          return {
            html: `${args.seriesName} | Total<div class='currency'>${args.valueText}</div>`,
          };
        },
      },
      size: {
        height: 200,
      },
      adaptiveLayout: {
        width: 450,
      },
    }).dxChart('instance');
  
    const pivotGrid = $('#pivotgrid').dxPivotGrid({
      allowSortingBySummary: true,
      allowFiltering: true,
      showBorders: true,
      showColumnGrandTotals: true,
      showRowGrandTotals: true,
      showRowTotals: true,
      showColumnTotals: true,
      fieldChooser: {
        enabled: true,
        height: 400,
        title: "Selector campos"
      },
      dataSource: {
        fields: [{
          caption: 'Region',
          width: 120,
          dataField: 'region',
          area: 'row',
          sortBySummaryField: 'Total',
        }, {
          caption: 'City',
          dataField: 'city',
          width: 150,
          area: 'row',
        }, {
          dataField: 'date',
          dataType: 'date', 
          area: 'column',
        }, {
          groupName: 'date',
          groupInterval: 'month',
          visible: true,
        }, {
          caption: 'Total',
          dataField: 'amount',
          dataType: 'number', 
          summaryType: 'sum',
          format: {type: "currency", currency: "EUR", precision: 0 },
          area: 'data',
        }],
        store: sales,
      },
      export: {
        enabled: true
        },
        texts: {
            collapseAll: "Collapse All",
            dataNotAvailable: "N/A",
            expandAll: "Expand All",
            exportToExcel: "Exportar a fichero Excel",
            grandTotal: "Total General",
            noData: "No data",
            removeAllSorting: "Remove All Sorting",
            showFieldChooser: "Mostrar el selector de campos" ,
            sortColumnBySummary: "Sort {0} by This Column",
            sortRowBySummary: "Sort {0} by This Row",
            total: "{0} Total"
        },
    }).dxPivotGrid('instance');
  
    pivotGrid.bindChart(pivotGridChart, {
      dataFieldsDisplayMode: 'splitPanes',
      alternateDataFields: false,
    });
  
    function expand() {
      const dataSource = pivotGrid.getDataSource();
      dataSource.expandHeaderItem('row', ['North America']);
      dataSource.expandHeaderItem('column', [2013]);
    }
  
    DevExpress.localization.locale(navigator.language);

    setTimeout(expand, 0);
  });