$(() => {

  const pivotGridChart = $('#pivotgrid-chart').dxChart({
    commonSeriesSettings: {
      type: 'line',  // 'bar','line','area','bubble'
    },
    palette: 'Soft', // 'Bright' | 'Harmony Light' | 'Ocean' | 'Pastel' | 'Soft' | 'Soft Pastel' | 'Vintage' | 'Violet' | 'Carmine' | 'Dark Moon' | 'Dark Violet' | 'Green Mist' | 'Soft Blue' | 'Material' | 'Office' 
    export: {
      enabled: true,
    },
    
    legend: {
          verticalAlignment: 'bottom',
          horizontalAlignment: 'center',
          visible: false
    },
    
    tooltip: {
      enabled: true,
      format: {type: "decimal"},
      customizeTooltip(args) {
        const myArray = args.seriesName.split(" ");
        sigla = myArray[0];
        return {
          html: `${sigla} <div class='currency'>${args.valueText}</div>`,
        };
      },
    },
    size: {
      height: 300,
    },
    // adaptiveLayout: {
    //   width: 0,
    // },
  }).dxChart('instance');

  const pivotGrid = $('#pivotgrid').dxPivotGrid({
    allowSortingBySummary: true,
    allowFiltering: true,
    showBorders: true,
    showColumnGrandTotals: false,
    showRowGrandTotals: false,
    showRowTotals: false,
    showColumnTotals: false,
    height: '750px',
    width: '1000px' ,
    encodeHtml: false,
    
    fieldChooser: {
      enabled: true,
      // allowSearch: true,
      height: 400,
      title: "Selector campos"
    },
    dataSource: {
      fields: [{
        caption: 'Siglas',
        width: 100,
        dataField: 'Siglas',
        area: 'row',
        expanded: true,
        sortBySummaryField: 'Votos',
        sortOrder: 'desc',
      }, {
          caption: 'Candidatura',
          dataField: 'Candidatura',
          width: 100,
          
        
      }, {
        caption: 'Convocatoria',
        dataField: 'Convocatoria',
        width: 50,
        area: 'column',
      }, {
        caption: 'Color',
        dataField: 'Color',
        width: 20,
        area: 'row',     
        customizeText: function(cellInfo) {
          return "<div id=\"colors\" style=\"background-color: " +cellInfo.value + ";width: 15px ; height: 15px;  border: 1px solid #DDDDDD ;border-radius:3px;\"> </div>";
        },
      }
      , {
        caption: 'Escaños',
        dataField: 'Escaños',
        dataType: 'number', 
        summaryType: 'sum',
        format: {type: "decimal" },
        area: 'data',
        sortOrder: 'desc',
      }, {
          caption: 'Votos',
          dataField: 'Votos',
          dataType: 'number', 
          summaryType: 'sum',
          format:  "##,###,##0",
          area: 'data',
          sortOrder: 'desc',
      }, {
          caption: '% Votos',
          dataField: '% Votos',
          dataType: 'number', 
          summaryType: 'sum',
          format: "#0.00'%'",
          area: 'data',
          sortOrder: 'desc',
      },
      ],
      store: votos,
    },
    export: {
      enabled: true
      },
      texts: {
          collapseAll: "Collapse All",
          dataNotAvailable: "N/A",
          expandAll: "Expand All",
          exportToExcel: "Exportar a fichero Excel",
          grandTotal: "Total General",
          noData: "No data",
          removeAllSorting: "Remove All Sorting",
          showFieldChooser: "Mostrar el selector de campos" ,
          sortColumnBySummary: "Sort {0} by This Column",
          sortRowBySummary: "Sort {0} by This Row",
          total: "{0} Total"
      },
    // fields['Convocatoria'].expanded,

  }).dxPivotGrid('instance');

  pivotGrid.bindChart(pivotGridChart, {
    dataFieldsDisplayMode: 'splitPanes',
    alternateDataFields: false,
    customizeSeries: function (seriesName, seriesOptions) {
      // console.log('Serie: ',seriesName);
      // console.log('Opciones: ',seriesOptions);
      const myArray = seriesName.split(" ");
      // console.log('array: ',myArray);
      // Search Colors
      const index = colors.findIndex(object => {
          return object.Siglas === myArray[0];
        });
      if(index > -1){
          seriesOptions.color = colors[index]['Color'];
          // console.log('Index: ',index); // SET Color
          // console.log('Color: ',colors[index]['Color']);
      }

      // if(!seriesName.includes("Votos")) seriesOptions.color = "red"
      
      return seriesOptions;
    }
  });
  
  
  function expand() {
    const dataSource = pivotGrid.getDataSource();
    /*
    dataSource.expandHeaderItem('row', ['North America']);
    dataSource.expandHeaderItem('column', [2013]);
    */
  }

  DevExpress.localization.locale(navigator.language);

  setTimeout(expand, 0);
});