<?php
// https://github.com/endroid/qr-code, source of Code

/* 
Occurs after record was updated  or added

$values     - array of values has been written to the database.
              To access specific field value use $values["FieldName"]
              "dict" is an alternate name for this parameter.              
$where      - WHERE clause that points to the edited record. Example: ID=19              
$oldvalues  - array with replaced field values. To access specific column value use
              $oldvalues["FieldName"]              
$keys       - array of key column values that point to the edited record. To access
              specific key column use $keys["KeyFieldName"]              
$inline     - equals to true when the Inline Edit in process, false otherwise              
$pageObject - an object of Page class representing the current page  
*/

// Load the QR library classes
require_once __DIR__ . '/../../ComponentCode/qr-code_4.4.9/autoload.php'; 

use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelLow;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;

$writer = new PngWriter();

// Create QR code
$qrCode = QrCode::create($values['Text'])
    ->setEncoding(new Encoding('UTF-8'))
    ->setErrorCorrectionLevel(new ErrorCorrectionLevelLow())
    ->setSize(200)
    ->setMargin(10)
    ->setRoundBlockSizeMode(new RoundBlockSizeModeMargin())
    ->setForegroundColor(new Color(0, 0, 0))
    ->setBackgroundColor(new Color(255, 255, 255));

// Create generic logo
/*
$logo = Logo::create(__DIR__.'/assets/symfony.png')
    ->setResizeToWidth(50);
*/

// Create generic label
/*
$label = Label::create('Label')
    ->setTextColor(new Color(255, 0, 0));
*/
$result = $writer->write($qrCode);


// Create name file
$fileName = 'QR_'.$values['idprueba_qr'].'.png';
$file = substr(__DIR__, 0, -6);  // root of file
$file = $file.'files/'.$fileName;

// Save it to a file
$result->saveToFile($file);

// Save the new file in Database

$size = filesize($file);
$fileArray = [];
$fileArray[0]['name']= 'files\/'.$fileName;
$fileArray[0]['usrName']= $fileName;
$fileArray[0]['size']= $size;
$fileArray[0]['type']= 'image\/png';
$fileArray[0]['searchStr'] = $fileName.',!:sStrEnd'; 
$fileFileSystem=my_json_encode($fileArray);
						
// Update in DB the file
$id_key = $values['idprueba_qr']; 
$sql="Update prueba_qr set File = '$fileFileSystem' where idprueba_qr = $id_key";
$res=db_exec($sql,$conn);

?>