<?php
// Función para saber si el usuario puede ejecuta las acciones sobre el expediente
// Function to know if the user can execute the actions on the expedient
function ControlAccesExpt(){

		$VidProcess = $_SESSION['idProcess'] ; 
		$Viduser=$_SESSION['iduser'];
		$sql="
		SELECT
		g.process_idprocess,
		sum(g.canAddExpedient) AddExpt,
		sum(g.canEditExpedient) EditExpt,
		sum(g.canViewExpedient) ViewExpt
		FROM access_group g join user_group u on (g.idaccess_group = u.access_group_idaccess_group )
		where g.process_idprocess = $VidProcess
		and u.user_iduser = $Viduser
		group by 1
		";
		$resql = DB::Query($sql);
		$row = $resql->fetchAssoc();
		$VAddExpt= $row['AddExpt'];
		$VEditExpt= $row['EditExpt'];
		$VViewExpt= $row['ViewExpt'];
		if ( $VAddExpt <> 0 ) {
			 $VAddExpt = 1 ;
				}	
		if ( $VEditExpt <> 0 ) {
			 $VEditExpt = 1 ;
				}	
		if ( $VViewExpt <> 0 ) {
			 $VViewExpt = 1 ;
				}	
		$_SESSION['CanDoAddExpt']=$VAddExpt; 
		$_SESSION['CanDoEditExpt']=$VEditExpt; 
		$_SESSION['CanDoViewExpt']=$VViewExpt; 
												
		return(true);
}


// Función para controlar si el acceso a la opción de trámite o Utilidad está autorizado para la sesión.
// Function to control whether access to the option of Task or Tool is authorized for the session.
function ControlAccess(){
  // global $pinfo; // Acceso a la opción que se está ejecutando || Access to the option that is running.
  // $Voption = $pinfo[filename].'.php'; // es la url corta que se está ejecutando || Short URL
  $portions = explode("?", $_SESSION['MyURL']);
  $portions = explode("/", $portions[0]);
  $Voption  = $portions[2]; 
  $VidExpedient=$_SESSION['idExpedient']; // Expediente con el que estamos trabajando || Expedient we are working with
  $Vfound= false; 
	
	// Analiza si es una petición de la gestión de bloqueos de registros || Analyze whether it is a request for the management of record blockages
	if ($_REQUEST['action'] == "confirm" && isset($_REQUEST['keys']) && isset($_REQUEST['rndval']) )
		{$Vfound = true;
			} else {
		  
		// control de si se ha cambiado el ID de Expedinte || check if the Expedient ID has been changed
		// $portions = explode("editid1=", $pinfo[extension]);
		// $data = explode("&", $portions[1]);
		// if ($data[0] == $VidExpedient) {
			if ($_REQUEST['editid1'] == $VidExpedient ) {

			// control de los trámites  || Control of Task or Proceeding
				if (isset($_SESSION['CodeTask'])) {
					foreach ($_SESSION['CodeTask'] as $Vtask) {
					if ($Vtask['UrlProceeding'] == $Voption) {
								$Vfound = true;
						}
					}
					// control de las utilidades || Control of Utilities
					foreach ($_SESSION['CodeUtil'] as $Vutil) {
					if ($Vutil['UrlUtility'] == $Voption) {
								$Vfound = true;
						}
					}
				}
			}
	}
return($Vfound);
}


   // Carga Lista de Utilidades del Usuario Conectado || Load User Tools /Utility List Connected
function LoadUtilityList() {
	unset ($_SESSION['CodeUtil']);
	$_SESSION['CodeUtil']=array();
   //**********  Carga lista de utilidades que puede utilizar el usuario || Load list of utilities that the user can use ********
	$Viduser=$_SESSION['iduser'];
	$VidProcess=$_SESSION['idProcess'];
	$Vlanguage=$_SESSION['language'];
	$VsuperCodeUtility=$_SESSION['superCodeUtility'];
	$sql = "
SELECT distinct
a.process_idprocess,
us.user_iduser,
u.idct_utility, u.catalogNum, u.importanceWeight, u.urlUtility, t.catalogCode
FROM access_group a
join utility_group ug on (ug.access_group_idaccess_group = a.idaccess_group)
join ct_utility u on (ug.ct_utility_idct_utility = u.idct_utility)
join user_group us on (us.access_group_idaccess_group = ug.access_group_idaccess_group)
join (SELECT
      c.catalogNum,
      c.catalogCode
      FROM catalog AS c
      INNER JOIN super_catalog AS s ON (c.super_catalog_idsuper_catalog = s.idsuper_catalog)
      where s.superCode = '$VsuperCodeUtility'
       and c.`language` = '$Vlanguage') t on (t.catalogNum = u.catalogNum)
where
a.process_idprocess = $VidProcess
and us.user_iduser = $Viduser
order by u.importanceWeight
";
	$resql = DB::Query($sql);
	while (true) {
		$data = $resql->fetchAssoc();
      if($data)
      {
            $VTitleMenu=$data['catalogCode'];
            $VCodeMenu=$data['catalogNum'];
            $VUrlUtility=$data['urlUtility'];
						 $VidUtility=$data['idct_utility'];
            $_SESSION['CodeUtil'][]=array('TitleMenu'=>$VTitleMenu,'CodeMenu'=>$VCodeMenu,'UrlUtility'=>$VUrlUtility,
                       'idUtility'=>$VidUtility);
      }
      else
      {
          break;
      }
   }
}

// Carga Lista de Trámites del Expediente y Usuario Conectado || Load List ofTasks of the Expedient and Connected User
function LoadTaskList() {
  unset ($_SESSION['CodeTask']);
  $_SESSION['CodeTask']=array();
	$Viduser=$_SESSION['iduser'];
	$VidProcess=$_SESSION['idProcess'];
	$Vlanguage=$_SESSION['language'];
	$VsuperCodeProceeding=$_SESSION['superCodeProceeding'];
	$VidStatus = $_SESSION['idStatus'];
//    control de si el Expte tiene asignación de usuario y si es el conectado  ||  control if the Expte has user assignment and if it is the connected one
   if ( $_SESSION['iduser_assigned'] ==  Null || $_SESSION['iduser_assigned'] == $_SESSION['iduser']){

				$sql="
SELECT distinct
-- ug.user_iduser,
-- ag.process_idprocess,
-- sg.ct_status_idct_status,
pr.catalogNum, pr.importanceWeight, pr.urlProceeding, pr.idct_proceeding, t.catalogCode
FROM user_group ug
join access_group ag on ( ag.idaccess_group = ug.access_group_idaccess_group)
join status_group sg on ( sg.access_group_idaccess_group = ug.access_group_idaccess_group)
join status_proceeding sp on (sp.ct_status_idct_status = sg.ct_status_idct_status)
join ct_proceeding pr on ( pr.idct_proceeding = sp.ct_proceeding_idct_proceeding)
join (SELECT
      c.catalogNum,
      c.catalogCode
      FROM `catalog` AS c
      INNER JOIN super_catalog AS s ON (c.super_catalog_idsuper_catalog = s.idsuper_catalog)
      where s.superCode = '$VsuperCodeProceeding'
       and c.`language` = '$Vlanguage') t on (t.catalogNum = pr.catalogNum)
where
ug.user_iduser = $Viduser and
ag.process_idprocess = $VidProcess and
sg.ct_status_idct_status = $VidStatus

order by pr.importanceWeight
";

				$resql = DB::Query($sql);
				while ($fila = $resql->fetchAssoc() ){
					$_SESSION['CodeTask'][]=array(
					'idct_proceeding'=>$fila['idct_proceeding'],
					'TitleMenu'=>$fila['catalogCode'], 
					'CodeMenu'=>$fila['catalogNum'], 
					'UrlProceeding'=>$fila['urlProceeding'] );
			}
	}
	// echo "<pre>";print_r($_SESSION['CodeTask']);echo "</pre>";
}

// Inserta registro en el LOG de  Trámites  realizados  || Insert record in the LOG of tasks performed
function InsertLogTask($values, $oldvalues){

	$data = array();
	$data["expedient_idexpedient"] = $_SESSION['idExpedient'] ;
	$data["ct_proceeding_idct_proceeding"]  = $_SESSION['idProceeding'] ;
	$data["ct_utility_idct_utility"] = Null;
	$data["beforeStatus"] = $oldvalues['ct_status_idct_status'];
	$data["afterStatus"] = $values['ct_status_idct_status'];
	$data["observations"] = $values['Observations'];
	$data["lastUpdateDate"] = now();
	$data["lastUpdateUser"] = $_SESSION['login'];
	DB::Insert("process_logbook", $data );
}

// Inserta registro en el LOG de  Utilidades  realizados  || Insert record in the LOG of tools performed
function InsertLogUtil($values, $oldvalues){

// si no se está actualizando la tabla de Expedientes || if the Expedient table is not being updated
if (isset($oldvalues['ct_status_idct_status'])) {
	$data = array();
	$data["expedient_idexpedient"] = $_SESSION['idExpedient'] ;
	$data["ct_proceeding_idct_proceeding"]  = Null ;
	$data["ct_utility_idct_utility"] = $_SESSION['idUtility'];
	$data["beforeStatus"] = $oldvalues['ct_status_idct_status'];
	$data["afterStatus"] = $values['ct_status_idct_status'];
	$data["observations"] = $values['Observations'];
	$data["lastUpdateDate"] = now();
	$data["lastUpdateUser"] = $_SESSION['login'];
	DB::Insert("process_logbook", $data );

	} else {

	$data = array();
	$data["expedient_idexpedient"] = $_SESSION['idExpedient'] ;
	$data["ct_proceeding_idct_proceeding"]  = Null ;
	$data["ct_utility_idct_utility"] = $_SESSION['idUtility'];
	$data["beforeStatus"] = Null;
	$data["afterStatus"] = Null;
	$data["observations"] = $values['Observations'];
	$data["lastUpdateDate"] = now();
	$data["lastUpdateUser"] = $_SESSION['login'];
	DB::Insert("process_logbook", $data );

	}



}

// Calcula los estados siguientes de un trámite - para la tramitación, lista de posibles valores  ||  Calculate the following states of a task - for processing, list of possible values
function FollowingStates($CodeProceeding){
	$VidProcess=$_SESSION['idProcess'];
	$sql="
SELECT
idct_status,
s.catalogNum CodeStatus
FROM proceeding_status ps
join ct_proceeding p on (p.idct_proceeding = ps.ct_proceeding_idct_proceeding )
join ct_status s on ( ps.ct_status_idct_status = s.idct_status)
where
p.catalogNum = '$CodeProceeding' and
p.process_idprocess = $VidProcess
";
	$resql = DB::Query($sql);
	$data = array();
	while ($fila = $resql->fetchAssoc()){
		$data[]=$fila['idct_status'];
	}
	return implode(",", $data);
}


// Función para dar número de Expediente  || Function to give Expedient number
function GiveExpedientNumber(){

$VCidProcess = $_SESSION['idProcess'];
$Vyear= date('Y'); // año con 4 cifras de la fecha actual	
$sql="
SELECT n.idnum_expedient, n.process_idprocess, n.codePrefix, n.year, n.nextNumber
FROM ct_num_expedient n
where n.process_idprocess = $VCidProcess
and n.year = $Vyear
";
$resql = DB::Query($sql);
$fila = $resql->fetchAssoc();
$VcodePrefix= $fila['codePrefix'];
$VnextNumber= $fila['nextNumber'];
$Vidnum_expedient = $fila['idnum_expedient'];
// Actualización del contador en la Tabla || Table counter update
$sql="update  ct_num_expedient
set nextNumber = nextNumber+1
where idnum_expedient = $Vidnum_expedient ";
DB::Exec($sql);
$VnextNumber=str_pad($VnextNumber, 6, "0", STR_PAD_LEFT);
return("$VcodePrefix/$VnextNumber/$Vyear");
}

// Función para dar número de Documento || Function to give Document number
function GiveDocumentNumber(){

$VCidProcess = $_SESSION['idProcess'];
$Vyear= date('Y'); // año con 4 cifras de la fecha actual	
$sql="SELECT n.idnum_document, n.codePrefix, n.year, n.nextNumber 
FROM ct_num_document n
where n.year = $Vyear";
$resql = DB::Query($sql);
$fila = $resql->fetchAssoc();
$VcodePrefix= $fila['codePrefix'];
$VnextNumber= $fila['nextNumber'];
$Vidnum_document = $fila['idnum_document'];
// Actualización del contador en la Tabla || Table counter update
$sql="UPDATE ct_num_document
set nextNumber =nextNumber+1
where idnum_document = $Vidnum_document ";
DB::Exec($sql);
$VnextNumber=str_pad($VnextNumber, 6, "0", STR_PAD_LEFT);
return("$VcodePrefix/$VnextNumber/$Vyear");
}

// Formateado de las fechas para la impresión en los documetos  | Formatting dates for printing on documents
function formatDate($fecha) {
  $fecha = substr($fecha, 0, 10);
  $numeroDia = date('d', strtotime($fecha));
  $dia = date('l', strtotime($fecha));
  $mes = date('F', strtotime($fecha));
  $anio = date('Y', strtotime($fecha));
  $dias_ES = array("Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado", "Domingo");
  $dias_EN = array("Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday");
  
  $meses_ES = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");
  $meses_EN = array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	if ($_SESSION['language'] == 'Spanish'){
			$nombredia = str_replace($dias_EN, $dias_ES, $dia);
			$nombreMes = str_replace($meses_EN, $meses_ES, $mes);
			// $return = $nombredia." ".$numeroDia." de ".$nombreMes." de ".$anio;
			$return = $numeroDia." de ".$nombreMes." de ".$anio;
	} else {
			$return = $numeroDia.' '.$mes.' '.$anio;
	}
  return $return;
}
?>