<?php

// Functión que construye toda la parte común que utiliza AnyChart cada vez que se invoca

function snippet_anychart($settings)
{
    $include = "MyCode/anychart.php";
    $libraries = ["anychart-base.min.js"];
    $theme = "";
    $language = "en-us.js";
    $decimalsCount = 2;
    $zeroFillDecimals = false;
    $decimalPoint = ".";
    $groupsSeparator = ",";
    $height = "";
    $id_container = "";
    $id_field = rand(1, 100000);
    

    if($settings["php_include"]) { $include=$settings["php_include"]; }
    if($settings["js_anychart"]) { $libraries=$settings["js_anychart"]; }
    if($settings["theme"]) { $theme=$settings["theme"]; }
    if($settings["language"]) { $language=$settings["language"]; }
    if($settings["decimalsCount"]) { $decimalsCount=$settings["decimalsCount"]; }
    if($settings["zeroFillDecimals"]) { $zeroFillDecimals=$settings["zeroFillDecimals"]; }
    if($settings["decimalPoint"]) { $decimalPoint=$settings["decimalPoint"]; }
    if($settings["groupsSeparator"]) { $groupsSeparator=$settings["groupsSeparator"]; }
    if($settings["height"]) { $height=$settings["height"]; }
    if($settings["id_container"]) { $id_container=$settings["id_container"]; }
    if($settings["id_field"]) { $id_field=$settings["id_field"]; }

    if ($id_field == '') $id_field = rand(1, 100000);
  
    $javascript = '';

    foreach ($libraries as &$file) { 
        $javascript .= <<<EOT
            
 <script src="plugins/controles/anychart/js/$file" charset="utf-8"></script>
 
EOT;
        }          
    if ($theme <>'') {
        $theme = "<script src=\"plugins/controles/anychart/themes/".$theme ."\"></script>";
    } else {
        $theme = '';
    }
    
    if ($language <>'') {
        $language = "<script src=\"plugins/controles/anychart/locales/".$language ."\"></script>";
    } else {
        $language = '';
    }
    if ($id_container <>'') {
        $id_field = $id_container;
    } 
    
    if ($height == '') {
        $style = <<<EOT
 <style> 
@media screen and (max-width:320px) {
  html, body, #container_$id_field {width: 100%; height: 200px; margin: 0; padding: 0; } 
}
@media screen and (max-width:480px) and (min-width:320px) {
  html, body, #container_$id_field {width: 100%; height: 250px; margin: 0; padding: 0; }
}
@media screen and (max-width:768px) and (min-width:480px) {
  html, body, #container_$id_field {width: 100%; height: 300px; margin: 0; padding: 0; }
}
@media screen and (max-width:1024px) and (min-width:768px) {
  html, body, #container_$id_field {width: 100%; height: 400px; margin: 0; padding: 0; }
}
@media screen and (min-width:1024px) {
  html, body, #container_$id_field {width: 100%; height: 500px; margin: 0; padding: 0; } 
}
</style>
EOT;
    } else {
    $p_heigth = $height;
    $style = <<<EOT
  <style> 
@media screen and (min-width:320px) {
  html, body, #container_$id_field {width: 100%; height: $p_heigth; margin: 0; padding: 0; } 
}
</style>
EOT;
    }
    
    $license = <<<EOT

// Set your licence key before you create chart.
anychart.licenseKey('xlinesoft-9faa5dd-332123fd'); 
// Set logo source.
// You can't customize credits without a license key. See https://www.anychart.com/buy/ to learn more.
var credits = chart.credits();
credits.enabled(false);
credits.logoSrc('');
    
EOT;

    $field_value = <<<EOT

<link REL="stylesheet" href="plugins/controles/anychart/css/anychart-ui.min.css" type="text/css">
$javascript
$language
$theme

$style

<div id="container_$id_field"></div>
	
<script type="text/javascript">
// window.onload = function() {
anychart.onDocumentReady(function() {
                    
  // Format Number
anychart.format.locales.default.numberLocale.zeroFillDecimals = $zeroFillDecimals;
anychart.format.locales.default.numberLocale.decimalsCount = $decimalsCount;
anychart.format.locales.default.numberLocale.groupsSeparator = "$groupsSeparator";
anychart.format.locales.default.numberLocale.decimalPoint = "$decimalPoint";


EOT;

    include $include;
    
    // echo $field_value;
    return ($field_value);
}

?>