<?php

function single_execution( $semaphore, $process ) {

    $path_semaphore = __DIR__."/semaphores/".$semaphore.".lock";
    
    $fp = fopen($path_semaphore, "r+");
    if ($fp == false ) { // file not found
        return array(false ,"The semaphore file does not exist!");
    }
    
    if (!flock($fp, LOCK_EX|LOCK_NB, $blocked)) {
        if ($blocked) {
    
            // another process holds the lock
            return array(false, "Couldn't get the lock! Other script in run!"); 
    
        }
        else {
            // couldn't lock for another reason, e.g. no such file
            return array(false , "Error! Nothing done.");
        }
    }
    else {
        // lock obtained
        ftruncate($fp, 0);  // truncate file
        
        // execute Proccess
        include ($process);
    
        fflush($fp);            // flush output before releasing the lock
        flock($fp, LOCK_UN);    // release the lock
        
        return array(true, "Process executed correctly");
    
    }
}