<?php
require_once("include/dbcommon.php"); // DataBase PHPRunner

// Require our Event class and datetime utilities
require 'fullcalendar/php/utils.php';

// Short-circuit if the client did not give us a date range.
if (!isset($_GET['start']) || !isset($_GET['end'])) {
  die("Please provide a date range.");
}

// Parse the start/end parameters.
// These are assumed to be ISO8601 strings with no time nor timeZone, like "2013-12-29".
// Since no timeZone will be present, they will parsed as UTC.
$range_start = parseDateTime($_GET['start']);
$range_end = parseDateTime($_GET['end']);

// Parse the timeZone parameter if it is present.

$time_zone ='UTC';
if (isset($_GET['timeZone'])) {
//   $time_zone = new DateTimeZone($_GET['timeZone']);
}


$start = substr($_GET['start'],0,10).' 00:00:00'; 
$end   = substr($_GET['end']  ,0,10).' 00:00:00';
$now   = date('Y-m-d H:i:s', strtotime(now(). ' +2 hour')); // now() + 1
if ( $start < $now ) { //  Minimum date of the moment
//		$start = $now;
		}
$language = $_SESSION['language'];

$strSQL = $_SESSION['timeline_sql'];
$strWhereClause = $_SESSION['timeline_where'];

$where = ' AND ';
if ($strWhereClause == '') {
		$where = ' WHERE ';
}

$sql = $strSQL . $where. " t1.end_date >= '$start' and t1.start_date <= '$end' ";

custom_error(4,"SQL de Eventos Timeline : ".$sql); // To debug  

$resql = DB::Query($sql); 
// Accumulate an output array of event data arrays.
$output_arrays = array();

while ($data = $resql->fetchAssoc()){  
$e_start = substr($data['start_date'],0,10); 
$e_end   = substr($data['end_date'],0,10).' 00:00:00';
$output_arrays[] = array(
    'id'=>$data['user_task_id'],
    'title'=>$data['perc_assignment'].' %'.' - '.$data['login'],
    'resourceId'=>$data['t3_users_user_id'],
    'start'=>$e_start,
    'end'=>date('Y-m-d', strtotime($e_end. ' +1 day')),
    'description'=>$data['username']);
    }

// Send JSON to the client.
// $str = json_encode($output_arrays);
echo json_encode($output_arrays);

?>