<?php

/**
 *
 * @About:      API Interface
 * @File:       index.php
 * @Date:       $Date:$ Agosot0 -2022
 * @Version:    $Rev:$ 1.0
 * @Developer:  Federico Guzman || Modificado por Fernando Humanes para PHP 8.1
 **/

/* Los headers permiten acceso desde otro dominio (CORS) a nuestro REST API o desde un cliente remoto via HTTP
 * Removiendo las lineas header() limitamos el acceso a nuestro RESTfull API a el mismo dominio
 * Nótese los métodos permitidos en Access-Control-Allow-Methods. Esto nos permite limitar los métodos de consulta a nuestro RESTfull API
 * Mas información: https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS
 **/
header("Access-Control-Allow-Origin: *");
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: PUT, GET, POST, DELETE, OPTIONS');
header("Access-Control-Allow-Headers: X-Requested-With");
header('Content-Type: text/html; charset=utf-8');
header('P3P: CP="IDC DSP COR CURa ADMa OUR IND PHY ONL COM STA"');

include_once '../include/Config.php';

require_once("../../include/dbcommon.php"); // DataBase PHPRunner

// use App\Models\Db;  // Utilizamos la conexión de PHPRunner
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use Selective\BasePath\BasePathMiddleware;
use Slim\Factory\AppFactory;

require_once __DIR__ . '/../libs/autoload.php';



$app = AppFactory::create();


$app->addRoutingMiddleware();
// $app->add(new BasePathMiddleware($app)); // No usar si se ejecuta en subdirectorio
$app->addErrorMiddleware(true, true, true);
$app->addBodyParsingMiddleware();

$app->setBasePath(SCRIPTS_DIR);

// --------------------------------------------------------------------------------------

/* Usando GET para consultar los autos */

$app->get('/auto', function(Request $request, Response $response) {
    
    $responseBody = array();
    $autos = array();

    $sql="SELECT brand.`Brand`,model.`Model`,car.`Year`,car.`Price` FROM car
    join brand on (car.`brand_idbrand` = brand.`idbrand`)
    join model on (car.`model_idmodel` = model.`idmodel`)
    order by 1,2,3,4";
    try {
    global $conn;

    $rsSql=$conn->query($sql);
    while ($data = $rsSql->fetch_array(MYSQLI_ASSOC)){
			$importe = number_format($data['Price'], 2, '.', ',');
			$autos[] = array('make'=>$data['Brand'], 'model'=>$data['Model'], 'year'=>$data['Year'], 'MSRP'=>$importe);
    }
    $responseBody["error"] = false;
    $responseBody["message"] = "Autos cargados: " . count($autos); //podemos usar count() para conocer el total de valores de un array
    $responseBody["autos"] = $autos;

    $response->getBody()->write(json_encode($responseBody));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);

    } catch (mysqli_sql_exception $e) {
        $error = array(
            "message" => $e->getMessage()
        );
        $response->getBody()->write(json_encode($error));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(500);
    }
});

// --------------------------------------------------------------------------------------

/* Usando POST para crear un auto */

$app->post('/auto', function(Request $request, Response $response) {
    // Verify Token Security
    $verify = authenticate($request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(400);
    }
    // check for required params
    $verify = verifyRequiredParams(array('make', 'model', 'year','msrp'), $request, $response);
    if (is_array($verify)) { // Si es una array, es que hay error
        $response->getBody()->write(json_encode($verify));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(400);
    }
    $data = $request->getParsedBody();

    $responseBody = array();
    $param = array();
    //capturamos los parametros recibidos y los almacxenamos como un nuevo array
    $param['make']  = $data['make'];
    $param['model'] = $data['model'];
    $param['year']  = $data['year'];
    $param['msrp']  = $data['msrp'];
    
    /* Podemos inicializar la conexion a la base de datos si queremos hacer uso de esta para procesar los parametros con DB */
    require_once '../include/DbAuto.php';
    $db = new DbAuto();

    /* Podemos crear un metodo que almacene el nuevo auto, por ejemplo: */
    $auto = $db->createAuto($param);

    if ( is_array($auto) ) {
        $responseBody["error"] = false;
        $responseBody["message"] = "Auto creado satisfactoriamente!";
        $responseBody["auto"] = $param;
        $response->getBody()->write(json_encode($responseBody));
        return $response
            ->withHeader('content-type', 'application/json')
            ->withStatus(200);
    } else {
        $responseBody["error"] = true;
        $responseBody["message"] = "Error al crear auto. Por favor intenta nuevamente.";
        return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(400);
    }
});

// --------------------------------------------------------------------------------------

/* Usando GET para consultar los modelos */

$app->get('/modelo', function(Request $request, Response $response) {
    
    $responseBody = array();
    $modelos = array();

    global $conn;

    $sql="SELECT brand.`Brand`, model.`Model` 
          FROM brand 
          join model on (model.`brand_idbrand` = brand.`idbrand`) 
          order by 1,2";
    $rsSql= DB::Query($sql);

    while ($data = $rsSql->fetchAssoc()){
	    $modelos[] = array('make'=>$data['Brand'], 'model'=>$data['Model']);
    }   
    $responseBody["error"] = false;
    $responseBody["message"] = "Modelos cargados: " . count($modelos); //podemos usar count() para conocer el total de valores de un array
    $responseBody["modelos"] = $modelos;

    $response->getBody()->write(json_encode($responseBody));
    return $response
        ->withHeader('content-type', 'application/json')
        ->withStatus(200);
});

// --------------------------------------------------------------------------------------


/* corremos la aplicación */
$app->run();

/*********************** USEFULL FUNCTIONS **************************************/

/**
 * Verificando los parametros requeridos en el metodo
 */
function verifyRequiredParams($required_fields, Request  $request, Response $response)
{
    $error = false;
    $error_fields = "";

    $request_params = $request->getParsedBody();

    foreach ($required_fields as $field) {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0) {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }

    if ($error) {
        // Required field(s) are missing or empty
        // echo error json and stop the app
        $responseBody = array();
        $responseBody["error"] = true;
        $responseBody["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';

        return $responseBody;
    }
    return true;
}

/**
 * Validando parametro email si necesario; un Extra ;)
 */
function validateEmailRest($email, Request $request, Response $response)
{
    $responseBody = array();
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $responseBody["error"] = true;
        $responseBody["message"] = 'Email address is not valid';
        return $responseBody;
    }
    return true;
}



/**
 * Revisa si la consulta contiene un Header "Authorization" para validar
 */
function authenticate(Request $request, Response $response)
{
    // Getting request headers
    $headers = $request->getHeaders();
    // Verifying Authorization Header
    if (isset($headers['Authorization'])) {
        // get the api key
        $token = $headers['Authorization'];

        // validating api key
        if (!($token[0] == API_KEY)) { //API_KEY declarada en Config.php

            // api key is not present in users table
            $responseBody["error"] = true;
            $responseBody["message"] = "Acceso denegado. Token inválido";
            // Error 401
            return $responseBody;
        } else {
            //procede utilizar el recurso o metodo del llamado
            return true;
        }
    } else {
        // api key is missing in header
        $responseBody["error"] = true;
        $responseBody["message"] = "Falta token de autorización";
        // error 400
        return $responseBody;
    }
}
