<?php

function CountDown ( $limitDate, $numberDiv ) {
// Param INPUT = $limitDate
// Param OUTPUT = $html
$html =<<<EOT
<div class="tick" data-did-init="handleTickInit$numberDiv">
    <div data-repeat="true" data-layout="horizontal fit" data-transform="preset(d, h, m, s) -> delay">
        <div class="tick-group">
            <div data-key="value" data-repeat="true" data-transform="pad(00) -> split -> delay">
                <span data-view="flip"></span>
            </div>
            <span data-key="label" data-view="text" class="tick-label"></span>
        </div>
    </div>
</div>
<script>
    function handleTickInit$numberDiv(tick) {
        // uncomment to set labels to different language
        /*
        var locale = {
            YEAR_PLURAL: 'Jaren',
            YEAR_SINGULAR: 'Jaar',
            MONTH_PLURAL: 'Maanden',
            MONTH_SINGULAR: 'Maand',
            WEEK_PLURAL: 'Weken',
            WEEK_SINGULAR: 'Week',
            DAY_PLURAL: 'Dagen',
            DAY_SINGULAR: 'Dag',
            HOUR_PLURAL: 'Uren',
            HOUR_SINGULAR: 'Uur',
            MINUTE_PLURAL: 'Minuten',
            MINUTE_SINGULAR: 'Minuut',
            SECOND_PLURAL: 'Seconden',
            SECOND_SINGULAR: 'Seconde',
            MILLISECOND_PLURAL: 'Milliseconden',
            MILLISECOND_SINGULAR: 'Milliseconde'
        };

        for (var key in locale) {
            if (!locale.hasOwnProperty(key)) { continue; }
            tick.setConstant(key, locale[key]);
        }
        */

        // format of due date is ISO8601
        // https://en.wikipedia.org/wiki/ISO_8601

        // '2018-01-31T12:00:00'        to count down to the 31st of January 2018 at 12 o'clock
        // '2019'                       to count down to 2019
        // '2018-01-15T10:00:00+01:00'  to count down to the 15th of January 2018 at 10 o'clock in timezone GMT+1

        // create the countdown counter
        // var counter = Tick.count.down('2023-12-31T00:00:00+01:00');
				 var counter = Tick.count.down('$limitDate');

        counter.onupdate = function(value) {
          tick.value = value;
        };

        counter.onended = function() {
            // redirect, uncomment the next line
            // window.location = 'my-location.html'

            // hide counter, uncomment the next line
            // tick.root.style.display = 'none';

            // show message, uncomment the next line
            // document.querySelector('.tick-onended-message').style.display = '';
        };
    }
</script>

<div class="tick-onended-message" style="display:none">
    <p>Time's up</p>
</div>
EOT;

return $html;
}
