<?php
// Required by PHPRunner (security)
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");

// Load the PHPWord library classes
require_once __DIR__ . '/../phpword_1.0.0/autoload.php'; 
use PhpOffice\PhpWord\Element\TextRun;
// Load Merge DOCX
require_once __DIR__ . '/../docx_merge_1.2.0/autoload.php';
use DocxMerge\DocxMerge;


function listado_word(string $codigoProvincia, string $nombreProvincia ) 
{
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$decimal = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL); 
$decimal->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 2);
$decimal->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 2); // by default some locales got max 2 fraction digits
$entero = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL);
$entero->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 0);
$entero->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 0); 

// Template processor instance creation
$template_word = __DIR__.'/template.docx';
$templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template_word);

// -------------------- ^ cabecera necesaria para las plantillas de Word ------------------
$formatDate = date ( 'd/m/Y' ); // Fecha del informe
 
$templateProcessor->setValue('fecha',$formatDate); // Fecha del informe

$templateProcessor->setValue('c',$codigoProvincia); // Código de Provincia
$templateProcessor->setValue('provincia',$nombreProvincia); // Nombre de Provincia

// ---------------------------------------

$sql = "SELECT count(*) FROM rp_municipio where CodigoProvincia = '$codigoProvincia'";
$rs = DB::Query($sql);

$count_lines = $rs->value(0); // número de líneaas del informe
$templateProcessor->cloneRow('id', $count_lines);

$sql = 
"SELECT idrp_municipio, CodigoProvincia, CodigoMunicipio, NombreMunicipio FROM rp_municipio where CodigoProvincia = '$codigoProvincia'
Order By 4";

$rs = DB::Query($sql);
$countLines=0;
while ($data = $rs->fetchAssoc()) {
		$countLines=$countLines+1;
		$templateProcessor->setValue('id#'.$countLines, $entero->format($data['idrp_municipio']));
		$templateProcessor->setValue('codigo#'.$countLines, $data['CodigoMunicipio']);
		$templateProcessor->setValue('municipio#'.$countLines, $data['NombreMunicipio']);
		
	}

// -------------------- v pie para salvar el nuevo documento Word ------------------
$temp_file = tempnam(sys_get_temp_dir(), 'Word');
$templateProcessor->saveAS($temp_file);

return $temp_file;
}

// ------------------ Operation with file result -------------------------------------------

$file_arr = array();

$sql = 
"SELECT CodigoProvincia, NombreProvincia FROM rp_provincia order by 1";

$rs = DB::Query($sql);
while ($data1 = $rs->fetchAssoc()) {

    $temp_file = listado_word($data1['CodigoProvincia'],$data1['NombreProvincia'] );
    $file_arr[] = $temp_file;
} 
$result_file = tempnam(sys_get_temp_dir(), 'WOR');
unlink($result_file);
$result_file = str_replace('.','_',$result_file).'.docx';
$dm = new DocxMerge();
$dm->merge($file_arr,
    $result_file,
    true
 );
foreach ($file_arr as &$file_temp) {  // Delete temporal file
    unlink($file_temp);
}
$documento = file_get_contents($result_file);
unlink($result_file);  // delete file tmp

header("Content-Disposition: attachment; filename= listado_municipios_2.docx");
header('Content-Type: application/docx');
echo $documento;

?>
