<?php
// Required by PHPRunner (security)
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");

// Load the PHPWord library classes
require_once __DIR__ . '/../phpword_1.0.0/autoload.php'; 
use PhpOffice\PhpWord\Element\TextRun;


function listado_001() 
{
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$decimal = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL); 
$decimal->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 2);
$decimal->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 2); // by default some locales got max 2 fraction digits
$entero = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL);
$entero->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 0);
$entero->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 0); 

// Template processor instance creation
$template_word = __DIR__.'/template.docx';
$templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template_word);

// -------------------- ^ cabecera necesaria para las plantillas de Word ------------------
$formatDate = date ( 'd/m/Y' ); // Fecha del informe
 
$templateProcessor->setValue('fecha',$formatDate); // Fecha del informe

$sql = "SELECT count(*)  FROM rp_pais";
$rs = DB::Query($sql);

$count_lines = $rs->value(0); // número de líneaas del informe
$templateProcessor->cloneRow('id', $count_lines);

$sql = "SELECT idrp_pais, CodigoPais, IndicadorBaja, NombrePais FROM rp_pais ORDER BY CodigoPais";
$rs = DB::Query($sql);
$countLines=0;
while ($data = $rs->fetchAssoc()) {
		$countLines=$countLines+1;
		$templateProcessor->setValue('id#'.$countLines, $data['idrp_pais']);
		$templateProcessor->setValue('codigo#'.$countLines, $entero->format($data['CodigoPais']));
		$templateProcessor->setValue('nombre#'.$countLines, $data['NombrePais']);
		$templateProcessor->setValue('b#'.$countLines, $data['IndicadorBaja']);
		
	}



// -------------------- v pie para salvar el nuevo documento Word ------------------
$temp_file = tempnam(sys_get_temp_dir(), 'Word');
$templateProcessor->saveAS($temp_file);

return $temp_file;
}

// ------------------ Operation with file result -------------------------------------------
$temp_file = listado_001();  // Ejecución del listado
$documento = file_get_contents($temp_file);
unlink($temp_file);  // delete file tmp
header("Content-Disposition: attachment; filename= paises.docx");
header('Content-Type: application/docx');
echo $documento;
?>
