<?php
// Required by PHPRunner (security)
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");

// Load the PHPWord library classes
require_once __DIR__ . '/../phpword_1.0.0/autoload.php'; 
use PhpOffice\PhpWord\Element\TextRun;


function listado_001() 
{
// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$decimal = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL); 
$decimal->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 2);
$decimal->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 2); // by default some locales got max 2 fraction digits
$entero = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL);
$entero->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 0);
$entero->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 0); 

// Template processor instance creation
$template_word = __DIR__.'/template.docx';
$templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template_word);

// -------------------- ^ cabecera necesaria para las plantillas de Word ------------------
$formatDate = date ( 'd/m/Y' ); // Fecha del informe
 
$templateProcessor->setValue('fecha',$formatDate); // Fecha del informe

// Gráficos
$categories = array();
$series1 = array();
$sql = 
"SELECT idrp_provincia, rp_provincia.CodigoProvincia, NombreProvincia, COUNT(*) municipios
FROM rp_provincia left JOIN  rp_municipio on ( rp_provincia.CodigoProvincia = rp_municipio.CodigoProvincia )
Group by 1,2,3
Order By 4 desc";

$rs = DB::Query($sql);
for ($i = 1; $i <= 10; $i++) {
    $data = $rs->fetchAssoc();
	$categories[] = $data['NombreProvincia'];
	$series1[]= $data['municipios'];
}


// TYPE: 'pie', 'doughnut', 'line', 'bar', 'stacked_bar', 'percent_stacked_bar', 'column', 'stacked_column', 'percent_stacked_column', 'area', 'radar', 'scatter'
$chart = new PhpOffice\PhpWord\Element\Chart('column', $categories, $series1, Null, 'Municipios');
// 
$chart->getStyle()->setWidth(PhpOffice\PhpWord\Shared\Converter::inchToEmu(7))->setHeight(PhpOffice\PhpWord\Shared\Converter::inchToEmu(4));

$chart->getStyle()->setShowGridX(true);
$chart->getStyle()->setShowGridY(true);
$chart->getStyle()->setShowAxisLabels(true);
$chart->getStyle()->setShowLegend(false);
$chart->getStyle()->setDataLabelOptions(
[	'showVal' => true, // value
	'showCatName' => false, // category name
	'showLegendKey' => false, //show the cart legend
	'showSerName' => false, // series name
	'showPercent' => false,
	'showLeaderLines' => false,
	'showBubbleSize' => false
]);
/**
     * Set the valueLabelPosition setting
     * "none" - skips writing labels
     * "nextTo" - sets labels next to the value
     * "low" - sets labels are below the graph
     * "high" - sets labels above the graph.
**/
// $chart->getStyle()->setValueLabelPosition('high');



// r = right, l = left, t = top, b = bottom, tr = top right
$chart->getStyle()->setLegendPosition('t');

$templateProcessor->setChart('grafico', $chart);

// -------------------------------------------------------------------------------------------

$sql = "SELECT count(*)  FROM rp_provincia";
$rs = DB::Query($sql);

$count_lines = $rs->value(0); // número de líneaas del informe
$templateProcessor->cloneRow('id', $count_lines);

$sql = 
"SELECT idrp_provincia, rp_provincia.CodigoProvincia, NombreProvincia, COUNT(*) municipios
FROM rp_provincia left JOIN  rp_municipio on ( rp_provincia.CodigoProvincia = rp_municipio.CodigoProvincia )
Group by 1,2,3
Order By 4 desc";

$rs = DB::Query($sql);
$countLines=0;
while ($data = $rs->fetchAssoc()) {
		$countLines=$countLines+1;
		$templateProcessor->setValue('id#'.$countLines, $data['idrp_provincia']);
		$templateProcessor->setValue('codigo#'.$countLines, $entero->format($data['CodigoProvincia']));
		$templateProcessor->setValue('nombre#'.$countLines, $data['NombreProvincia']);
		$templateProcessor->setValue('municipios#'.$countLines, $data['municipios']);
		
	}



// -------------------- v pie para salvar el nuevo documento Word ------------------
$temp_file = tempnam(sys_get_temp_dir(), 'Word');
$templateProcessor->saveAS($temp_file);

return $temp_file;
}

// ------------------ Operation with file result -------------------------------------------
$temp_file = listado_001();  // Ejecución del listado
$documento = file_get_contents($temp_file);
unlink($temp_file);  // delete file tmp
header("Content-Disposition: attachment; filename= municipios.docx");
header('Content-Type: application/docx');
echo $documento;
?>
