<?php 
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

// Delete all ile temporal
function deleteAllFilesToDirectory(string $directory){
    $dir = $directory;
    if(file_exists($dir)){
        $di = new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS);
        $ri = new RecursiveIteratorIterator($di, RecursiveIteratorIterator::CHILD_FIRST);
        foreach ( $ri as $file ) {
            $file->isDir() ?  rmdir($file) : unlink($file);  
            // if ( $file->isDir()) {  echo "dir.: ".$file."\n"; } else { echo "file: ".$file."\n"; }
        }
    }   
}

require_once(__DIR__."/../include/dbcommon.php");

$ids_arr = $_SESSION['ids'];  // Recupera los ID seleccionados

$content_arr = array();
$list_id = implode(',',$ids_arr);
$sql = "SELECT * FROM zip_user WHERE ID IN($list_id)";
$rs = DB::Query($sql);
while( $data = $rs->fetchAssoc() )  // Load all record in Array
{
    $data['image'] = base64_encode($data['image']);
    $content_arr[] = $data;
}

$temp_directory = tempnam(sys_get_temp_dir(), 'exp');
unlink($temp_directory); // Elimino fichero temporal
$temp_directory =str_replace('.','_',$temp_directory);    // Quito "." en Windows

$temp_zip = str_replace('_tmp','',$temp_directory).".zip";   // Name file ZIP
mkdir($temp_directory,0700);  // directorio de exportación
$temp_directory_image = $temp_directory."/image";
mkdir($temp_directory_image,0700);  // directorio de imágenes
$error = error_get_last();
// Create images all record select
foreach ($content_arr as &$record) {
    $ext_file = explode('.',$record['filename']);
    $id = $record['id'];
    $temp_file = $temp_directory_image."/image_$id.".$ext_file[1];
    $fp = fopen($temp_file , 'wb');
    fwrite($fp, base64_decode($record['image']));
    fclose($fp);
}
// Create file CSV

$tmp_csv = $temp_directory."/export.csv";
$csv_arr = array();
$csv_arr[] = array('id','name','addDate','precio','filename');
// Format
$decimal = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL); 
$decimal->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 2);
$decimal->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 2); // by default some locales got max 2 fraction digits
$entero = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL);
$entero->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 0);
$entero->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 0); 

// date_format(date_create("2013-03-15"),"d/m/Y H:i:s");
// 
foreach ($content_arr as &$record) {
    $csv_arr[] = array($record['id'],$record['name'],date_format(date_create($record['addDate']),"d/m/Y"),
                 $decimal->format($record['precio']),$record['filename']);
}
$fp = fopen($tmp_csv, 'w');
foreach ($csv_arr as $line) {  // Write file CSV
    fputcsv($fp, $line);
}
fclose($fp);

// Create zip file
$zip = new ZipArchive();

if ($zip->open($temp_zip, ZipArchive::CREATE)!==TRUE) {
    exit("cannot open <$temp_zip>\n");
}
$zip->addFile($temp_directory."/export.csv","export.csv");
$options = array('add_path' => 'image/', 'remove_all_path' => TRUE);
$zip->addGlob($temp_directory_image.'/*.*', GLOB_BRACE, $options);
$zip->close();
// Download zip
$content_zip = file_get_contents($temp_zip);

deleteAllFilesToDirectory($temp_directory);  // Delete All file temporal
rmdir($temp_directory);
unlink($temp_zip);  // delete file zip

header("Content-Disposition: attachment; filename= export.zip");
header('Content-Type: application/zip');
echo $content_zip;
