// Generated by dts-bundle v0.7.3-fork.1
// Dependencies for this module:
//   ambient.d.ts

declare module '@fullcalendar/resource-common' {
    import '@fullcalendar/resource-common/ambient';
    import '@fullcalendar/resource-common/api/EventApi';
    import '@fullcalendar/resource-common/resource-sources/resource-array';
    import '@fullcalendar/resource-common/resource-sources/resource-func';
    import '@fullcalendar/resource-common/resource-sources/resource-json-feed';
    const _default: import("@fullcalendar/core").PluginDef;
    export default _default;
    export { default as ResourceDayHeader } from '@fullcalendar/resource-common/common/ResourceDayHeader';
    export { VResourceJoiner, AbstractResourceDayTable, ResourceDayTable, DayResourceTable, VResourceSplitter } from '@fullcalendar/resource-common/common/resource-day-table';
    export { Resource, ResourceHash } from '@fullcalendar/resource-common/structs/resource';
    export { ResourceViewProps } from '@fullcalendar/resource-common/View';
    export { flattenResources, Group, isGroupsEqual, GroupNode, ResourceNode, buildRowNodes, buildResourceFields } from '@fullcalendar/resource-common/common/resource-hierarchy';
    export { buildResourceTextFunc } from '@fullcalendar/resource-common/common/resource-rendering';
    export { default as ResourceApi } from '@fullcalendar/resource-common/api/ResourceApi';
    export { default as ResourceSplitter } from '@fullcalendar/resource-common/common/ResourceSplitter';
}

declare module '@fullcalendar/resource-common/ambient' {
    import ResourceApi from '@fullcalendar/resource-common/api/ResourceApi';
    import { ResourceSourceInput, ResourceSource } from '@fullcalendar/resource-common/structs/resource-source';
    import { View } from '@fullcalendar/core';
    import { ResourceHash } from '@fullcalendar/resource-common/structs/resource';
    import { ResourceEntityExpansions } from '@fullcalendar/resource-common/reducers/resourceEntityExpansions';
    import { ResourceAction } from '@fullcalendar/resource-common/reducers/resources';
    module '@fullcalendar/core' {
        interface Calendar {
            addResource(input: ResourceSourceInput): ResourceApi;
            getResourceById(id: string): ResourceApi | null;
            getResources(): ResourceApi[];
            getTopLevelResources(): ResourceApi[];
            rerenderResources(): void;
            refetchResources(): void;
        }
        interface Calendar {
            dispatch(action: ResourceAction): any;
        }
        interface CalendarState {
            resourceSource?: ResourceSource | null;
            resourceStore?: ResourceHash;
            resourceEntityExpansions?: ResourceEntityExpansions;
        }
        interface OptionsInput {
            schedulerLicenseKey?: string;
            resources?: ResourceSourceInput;
            resourceLabelText?: string;
            resourceOrder?: any;
            filterResourcesWithEvents?: any;
            resourceText?: any;
            resourceGroupField?: any;
            resourceGroupText?: any;
            resourceAreaWidth?: any;
            resourceColumns?: any;
            resourcesInitiallyExpanded?: any;
            slotWidth?: any;
            datesAboveResources?: any;
            eventResourceEditable?: boolean;
            refetchResourcesOnNavigate?: boolean;
            resourceRender?(arg: {
                resource: ResourceApi;
                el: HTMLElement;
                view: View;
            }): void;
        }
        interface DatePointApi {
            resource?: ResourceApi;
        }
        interface DateSpanApi {
            resource?: ResourceApi;
        }
        interface EventMutation {
            resourceMutation?: {
                matchResourceId: string;
                setResourceId: string;
            };
        }
        interface EventApi {
            getResources: () => ResourceApi[];
            setResources: (resources: (string | ResourceApi)[]) => void;
        }
        interface EventDef {
            resourceIds: string[];
            resourceEditable: boolean;
        }
    }
}

declare module '@fullcalendar/resource-common/api/EventApi' {
    import '@fullcalendar/resource-common/ambient';
}

declare module '@fullcalendar/resource-common/resource-sources/resource-array' {
    export {};
}

declare module '@fullcalendar/resource-common/resource-sources/resource-func' {
    import { ResourceSourceError } from '@fullcalendar/resource-common/structs/resource-source';
    import { ResourceInput } from '@fullcalendar/resource-common/structs/resource';
    export type ResourceFunc = (arg: {
        start: Date;
        end: Date;
        timeZone: string;
    }, successCallback: (events: ResourceInput[]) => void, failureCallback: (errorObj: ResourceSourceError) => void) => any;
}

declare module '@fullcalendar/resource-common/resource-sources/resource-json-feed' {
    export {};
}

declare module '@fullcalendar/resource-common/common/ResourceDayHeader' {
    import { Calendar, Component, DateMarker, DateProfile, DateFormatter, ComponentContext } from '@fullcalendar/core';
    import { Resource } from '@fullcalendar/resource-common/structs/resource';
    export interface ResourceDayHeaderProps {
        dates: DateMarker[];
        dateProfile: DateProfile;
        datesRepDistinctDays: boolean;
        resources: Resource[];
        renderIntroHtml?: () => string;
    }
    export { ResourceDayHeader as default, ResourceDayHeader };
    class ResourceDayHeader extends Component<ResourceDayHeaderProps> {
        datesAboveResources: boolean;
        resourceTextFunc: (resource: Resource) => string;
        dateFormat: DateFormatter;
        parentEl: HTMLElement;
        el: HTMLElement;
        thead: HTMLElement;
        constructor(parentEl: HTMLElement);
        _processOptions(options: any, calendar: Calendar): void;
        render(props: ResourceDayHeaderProps, context: ComponentContext): void;
        destroy(): void;
        renderResourceRow(resources: Resource[]): string;
        renderDayAndResourceRows(dates: DateMarker[], resources: Resource[]): string;
        renderResourceAndDayRows(resources: Resource[], dates: DateMarker[]): string;
        renderResourceCell(resource: Resource, colspan: number, date?: DateMarker): string;
        renderDateCell(date: DateMarker, colspan: number, resource?: Resource): string;
        buildTr(cellHtmls: string[]): string;
        processResourceEls(resources: Resource[]): void;
    }
}

declare module '@fullcalendar/resource-common/common/resource-day-table' {
    import { SlicedProps, EventDef, Splitter, DayTable, DayTableCell, SplittableProps, DateSpan, Seg, EventSegUiInteractionState } from '@fullcalendar/core';
    import { Resource } from '@fullcalendar/resource-common/structs/resource';
    export interface ResourceDayTableCell extends DayTableCell {
        resource: Resource;
    }
    export abstract class AbstractResourceDayTable {
        cells: ResourceDayTableCell[][];
        rowCnt: number;
        colCnt: number;
        dayTable: DayTable;
        resources: Resource[];
        resourceIndex: ResourceIndex;
        constructor(dayTable: DayTable, resources: Resource[]);
        abstract computeCol(dateI: any, resourceI: any): number;
        abstract computeColRanges(dateStartI: any, dateEndI: any, resourceI: any): {
            firstCol: number;
            lastCol: number;
            isStart: boolean;
            isEnd: boolean;
        }[];
        buildCells(): ResourceDayTableCell[][];
    }
    export class ResourceDayTable extends AbstractResourceDayTable {
        computeCol(dateI: any, resourceI: any): any;
        computeColRanges(dateStartI: any, dateEndI: any, resourceI: any): {
            firstCol: any;
            lastCol: any;
            isStart: boolean;
            isEnd: boolean;
        }[];
    }
    export class DayResourceTable extends AbstractResourceDayTable {
        computeCol(dateI: any, resourceI: any): any;
        computeColRanges(dateStartI: any, dateEndI: any, resourceI: any): any[];
    }
    export class ResourceIndex {
        indicesById: {
            [resourceId: string]: number;
        };
        ids: string[];
        length: number;
        constructor(resources: Resource[]);
    }
    export interface VResourceProps extends SplittableProps {
        resourceDayTable: AbstractResourceDayTable;
    }
    export class VResourceSplitter extends Splitter<VResourceProps> {
        getKeyInfo(props: VResourceProps): any;
        getKeysForDateSpan(dateSpan: DateSpan): string[];
        getKeysForEventDef(eventDef: EventDef): string[];
    }
    export abstract class VResourceJoiner<SegType extends Seg> {
        joinProps(propSets: {
            [resourceId: string]: SlicedProps<SegType>;
        }, resourceDayTable: AbstractResourceDayTable): SlicedProps<SegType>;
        joinSegs(resourceDayTable: AbstractResourceDayTable, ...segGroups: SegType[][]): SegType[];
        expandSegs(resourceDayTable: AbstractResourceDayTable, segs: SegType[]): any[];
        joinInteractions(resourceDayTable: AbstractResourceDayTable, ...interactions: EventSegUiInteractionState[]): EventSegUiInteractionState;
        abstract transformSeg(seg: SegType, resourceDayTable: AbstractResourceDayTable, resourceI: number): SegType[];
    }
}

declare module '@fullcalendar/resource-common/structs/resource' {
    import { ConstraintInput, AllowFunc, EventStore, Calendar, EventUi, BusinessHoursInput } from '@fullcalendar/core';
    export interface ResourceInput {
        id?: string;
        parentId?: string;
        children?: ResourceInput[];
        title?: string;
        businessHours?: BusinessHoursInput;
        eventEditable?: boolean;
        eventStartEditable?: boolean;
        eventDurationEditable?: boolean;
        eventConstraint?: ConstraintInput;
        eventOverlap?: boolean;
        eventAllow?: AllowFunc;
        eventClassName?: string[] | string;
        eventClassNames?: string[] | string;
        eventBackgroundColor?: string;
        eventBorderColor?: string;
        eventTextColor?: string;
        eventColor?: string;
        extendedProps?: {
            [extendedProp: string]: any;
        };
        [otherProp: string]: any;
    }
    export interface Resource {
        id: string;
        parentId: string;
        title: string;
        businessHours: EventStore | null;
        ui: EventUi;
        extendedProps: {
            [extendedProp: string]: any;
        };
    }
    export type ResourceHash = {
        [resourceId: string]: Resource;
    };
    export function parseResource(input: ResourceInput, parentId: string, store: ResourceHash, calendar: Calendar): Resource;
    export function getPublicId(id: string): string;
}

declare module '@fullcalendar/resource-common/View' {
    import { View, ViewProps, ViewSpec, ViewPropsTransformer, CalendarComponentProps, EventUi, EventUiHash, EventDefHash, EventDef, EventStore, DateRange } from '@fullcalendar/core';
    import { ResourceHash } from '@fullcalendar/resource-common/structs/resource';
    import { ResourceEntityExpansions } from '@fullcalendar/resource-common/reducers/resourceEntityExpansions';
    export interface ResourceViewProps extends ViewProps {
        resourceStore: ResourceHash;
        resourceEntityExpansions: ResourceEntityExpansions;
    }
    export class ResourceDataAdder implements ViewPropsTransformer {
        filterResources: typeof filterResources;
        transform(viewProps: ViewProps, viewSpec: ViewSpec, calendarProps: CalendarComponentProps, allOptions: any): {
            resourceStore: ResourceHash;
            resourceEntityExpansions: ResourceEntityExpansions;
        };
    }
    function filterResources(resourceStore: ResourceHash, doFilterResourcesWithEvents: boolean, eventStore: EventStore, activeRange: DateRange): ResourceHash;
    export class ResourceEventConfigAdder implements ViewPropsTransformer {
        buildResourceEventUis: typeof buildResourceEventUis;
        injectResourceEventUis: typeof injectResourceEventUis;
        transform(viewProps: ViewProps, viewSpec: ViewSpec, calendarProps: CalendarComponentProps): {
            eventUiBases: {
                [key: string]: EventUi;
            };
        };
    }
    function buildResourceEventUis(resourceStore: ResourceHash): {
        [key: string]: EventUi;
    };
    function injectResourceEventUis(eventUiBases: EventUiHash, eventDefs: EventDefHash, resourceEventUis: EventUiHash): {
        [key: string]: EventUi;
    };
    export function transformIsDraggable(val: boolean, eventDef: EventDef, eventUi: EventUi, view: View): boolean;
    export {};
}

declare module '@fullcalendar/resource-common/common/resource-hierarchy' {
    import { ResourceHash, Resource } from '@fullcalendar/resource-common/structs/resource';
    import { ResourceEntityExpansions } from '@fullcalendar/resource-common/reducers/resourceEntityExpansions';
    export interface Group {
        value: any;
        spec: any;
    }
    export interface GroupNode {
        id: string;
        isExpanded: boolean;
        group: Group;
    }
    export interface ResourceNode {
        id: string;
        rowSpans: number[];
        depth: number;
        isExpanded: boolean;
        hasChildren: boolean;
        resource: Resource;
        resourceFields: any;
    }
    export function flattenResources(resourceStore: ResourceHash, orderSpecs: any): Resource[];
    export function buildRowNodes(resourceStore: ResourceHash, groupSpecs: any, orderSpecs: any, isVGrouping: boolean, expansions: ResourceEntityExpansions, expansionDefault: boolean): (GroupNode | ResourceNode)[];
    export function buildResourceFields(resource: Resource): {
        id: string;
        parentId: string;
        title: string;
        businessHours: import("@fullcalendar/core").EventStore;
        ui: import("@fullcalendar/core").EventUi;
        extendedProps: {
            [extendedProp: string]: any;
        };
        startEditable: boolean;
        durationEditable: boolean;
        constraints: import("@fullcalendar/core").Constraint[];
        overlap: boolean;
        allows: import("@fullcalendar/core").AllowFunc[];
        backgroundColor: string;
        borderColor: string;
        textColor: string;
        classNames: string[];
    };
    export function isGroupsEqual(group0: Group, group1: Group): boolean;
}

declare module '@fullcalendar/resource-common/common/resource-rendering' {
    import { Resource } from '@fullcalendar/resource-common/structs/resource';
    export function buildResourceTextFunc(resourceTextSetting: any, calendar: any): (resource: Resource) => any;
}

declare module '@fullcalendar/resource-common/api/ResourceApi' {
    import { Calendar, EventApi } from '@fullcalendar/core';
    import { Resource } from '@fullcalendar/resource-common/structs/resource';
    export { ResourceApi as default, ResourceApi };
    class ResourceApi {
        _calendar: Calendar;
        _resource: Resource;
        constructor(calendar: Calendar, rawResource: Resource);
        setProp(name: string, value: any): void;
        remove(): void;
        getParent(): ResourceApi | null;
        getChildren(): ResourceApi[];
        getEvents(): EventApi[];
        readonly id: string;
        readonly title: string;
        readonly eventConstraint: any;
        readonly eventOverlap: any;
        readonly eventAllow: any;
        readonly eventBackgroundColor: string;
        readonly eventBorderColor: string;
        readonly eventTextColor: string;
        readonly eventClassNames: string[];
        readonly extendedProps: any;
    }
}

declare module '@fullcalendar/resource-common/common/ResourceSplitter' {
    import { Splitter, SplittableProps, DateSpan, EventDef } from '@fullcalendar/core';
    import { ResourceHash } from '@fullcalendar/resource-common/structs/resource';
    export interface SplittableResourceProps extends SplittableProps {
        resourceStore: ResourceHash;
    }
    export { ResourceSplitter as default, ResourceSplitter };
    class ResourceSplitter extends Splitter<SplittableResourceProps> {
        getKeyInfo(props: SplittableResourceProps): {
            '': {};
        };
        getKeysForDateSpan(dateSpan: DateSpan): string[];
        getKeysForEventDef(eventDef: EventDef): string[];
    }
}

declare module '@fullcalendar/resource-common/structs/resource-source' {
    import { DateRange, Calendar } from '@fullcalendar/core';
    import { ResourceInput } from '@fullcalendar/resource-common/structs/resource';
    import { ResourceFunc } from '@fullcalendar/resource-common/resource-sources/resource-func';
    export type ResourceSourceError = {
        message: string;
        xhr?: XMLHttpRequest;
        [otherProp: string]: any;
    };
    export type ResourceFetcher = (arg: {
        resourceSource: ResourceSource;
        calendar: Calendar;
        range: DateRange | null;
    }, success: (res: {
        rawResources: ResourceInput[];
        xhr?: XMLHttpRequest;
    }) => void, failure: (error: ResourceSourceError) => void) => void;
    export interface ExtendedResourceSourceInput {
        id?: string;
        resources?: ResourceInput[];
        url?: string;
        method?: string;
        extraParams?: object | (() => object);
    }
    export type ResourceSourceInput = ResourceInput[] | ExtendedResourceSourceInput | ResourceFunc | string;
    export interface ResourceSource {
        _raw: any;
        sourceId: string;
        sourceDefId: number;
        meta: any;
        publicId: string;
        isFetching: boolean;
        latestFetchId: string;
        fetchRange: DateRange | null;
    }
    export interface ResourceSourceDef {
        ignoreRange?: boolean;
        parseMeta: (raw: ResourceSourceInput) => object | null;
        fetch: ResourceFetcher;
    }
    export function registerResourceSourceDef(def: ResourceSourceDef): void;
    export function getResourceSourceDef(id: number): ResourceSourceDef;
    export function doesSourceIgnoreRange(source: ResourceSource): boolean;
    export function parseResourceSource(input: ResourceSourceInput): ResourceSource;
}

declare module '@fullcalendar/resource-common/reducers/resourceEntityExpansions' {
    import { ResourceAction } from '@fullcalendar/resource-common/reducers/resources';
    export type ResourceEntityExpansions = {
        [id: string]: boolean;
    };
    export function reduceResourceEntityExpansions(expansions: ResourceEntityExpansions, action: ResourceAction): ResourceEntityExpansions;
}

declare module '@fullcalendar/resource-common/reducers/resources' {
    import { Calendar, CalendarState, Action, DateRange } from '@fullcalendar/core';
    import { ResourceSourceError } from '@fullcalendar/resource-common/structs/resource-source';
    import { ResourceHash, ResourceInput } from '@fullcalendar/resource-common/structs/resource';
    export type ResourceAction = Action | {
        type: 'FETCH_RESOURCE';
    } | {
        type: 'RECEIVE_RESOURCES';
        rawResources: ResourceInput[];
        fetchId: string;
        fetchRange: DateRange | null;
    } | {
        type: 'RECEIVE_RESOURCE_ERROR';
        error: ResourceSourceError;
        fetchId: string;
        fetchRange: DateRange | null;
    } | {
        type: 'ADD_RESOURCE';
        resourceHash: ResourceHash;
    } | // use a hash because needs to accept children
    {
        type: 'REMOVE_RESOURCE';
        resourceId: string;
    } | {
        type: 'SET_RESOURCE_PROP';
        resourceId: string;
        propName: string;
        propValue: any;
    } | {
        type: 'SET_RESOURCE_ENTITY_EXPANDED';
        id: string;
        isExpanded: boolean;
    } | {
        type: 'RESET_RESOURCES';
    } | {
        type: 'RESET_RESOURCE_SOURCE';
        resourceSourceInput: any;
    } | {
        type: 'REFETCH_RESOURCES';
    };
    export default function (state: CalendarState, action: ResourceAction, calendar: Calendar): {
        resourceSource: import("@fullcalendar/resource-common/structs/resource-source").ResourceSource;
        resourceStore: ResourceHash;
        resourceEntityExpansions: import("@fullcalendar/resource-common/reducers/resourceEntityExpansions").ResourceEntityExpansions;
        eventSources: import("@fullcalendar/core").EventSourceHash;
        eventSourceLoadingLevel: number;
        loadingLevel: number;
        viewType: string;
        currentDate: Date;
        dateProfile: import("@fullcalendar/core").DateProfile;
        eventStore: import("@fullcalendar/core").EventStore;
        dateSelection: import("@fullcalendar/core").DateSpan;
        eventSelection: string;
        eventDrag: import("@fullcalendar/core").EventInteractionState;
        eventResize: import("@fullcalendar/core").EventInteractionState;
    };
}

