
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?factory(exports,require('@fullcalendar/core')):typeof define==='function'&&define.amd?define(['exports','@fullcalendar/core'],factory):(global=global||self,factory(global.FullCalendarGoogleCalendar={},global.FullCalendar));}(this,function(exports,core){'use strict';var __assign=function(){__assign=Object.assign||function __assign(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p];}
return t;};return __assign.apply(this,arguments);};var API_BASE='https://www.googleapis.com/calendar/v3/calendars';var STANDARD_PROPS={url:String,googleCalendarApiKey:String,googleCalendarId:String,googleCalendarApiBase:String,data:null};var eventSourceDef={parseMeta:function(raw){if(typeof raw==='string'){raw={url:raw};}
if(typeof raw==='object'){var standardProps=core.refineProps(raw,STANDARD_PROPS);if(!standardProps.googleCalendarId&&standardProps.url){standardProps.googleCalendarId=parseGoogleCalendarId(standardProps.url);}
delete standardProps.url;if(standardProps.googleCalendarId){return standardProps;}}
return null;},fetch:function(arg,onSuccess,onFailure){var calendar=arg.calendar;var meta=arg.eventSource.meta;var apiKey=meta.googleCalendarApiKey||calendar.opt('googleCalendarApiKey');if(!apiKey){onFailure({message:'Specify a googleCalendarApiKey. See http://fullcalendar.io/docs/google_calendar/'});}
else{var url=buildUrl(meta);var requestParams_1=buildRequestParams(arg.range,apiKey,meta.data,calendar.dateEnv);core.requestJson('GET',url,requestParams_1,function(body,xhr){if(body.error){onFailure({message:'Google Calendar API: '+body.error.message,errors:body.error.errors,xhr:xhr});}
else{onSuccess({rawEvents:gcalItemsToRawEventDefs(body.items,requestParams_1.timeZone),xhr:xhr});}},function(message,xhr){onFailure({message:message,xhr:xhr});});}}};function parseGoogleCalendarId(url){var match;if(/^[^\/]+@([^\/\.]+\.)*(google|googlemail|gmail)\.com$/.test(url)){return url;}
else if((match=/^https:\/\/www.googleapis.com\/calendar\/v3\/calendars\/([^\/]*)/.exec(url))||(match=/^https?:\/\/www.google.com\/calendar\/feeds\/([^\/]*)/.exec(url))){return decodeURIComponent(match[1]);}}
function buildUrl(meta){var apiBase=meta.googleCalendarApiBase;if(!apiBase){apiBase=API_BASE;}
return apiBase+'/'+encodeURIComponent(meta.googleCalendarId)+'/events';}
function buildRequestParams(range,apiKey,extraParams,dateEnv){var params;var startStr;var endStr;if(dateEnv.canComputeOffset){startStr=dateEnv.formatIso(range.start);endStr=dateEnv.formatIso(range.end);}
else{startStr=core.addDays(range.start,-1).toISOString();endStr=core.addDays(range.end,1).toISOString();}
params=__assign({},(extraParams||{}),{key:apiKey,timeMin:startStr,timeMax:endStr,singleEvents:true,maxResults:9999});if(dateEnv.timeZone!=='local'){params.timeZone=dateEnv.timeZone;}
return params;}
function gcalItemsToRawEventDefs(items,gcalTimezone){return items.map(function(item){return gcalItemToRawEventDef(item,gcalTimezone);});}
function gcalItemToRawEventDef(item,gcalTimezone){var url=item.htmlLink||null;if(url&&gcalTimezone){url=injectQsComponent(url,'ctz='+gcalTimezone);}
return{id:item.id,title:item.summary,start:item.start.dateTime||item.start.date,end:item.end.dateTime||item.end.date,url:url,location:item.location,description:item.description};}
function injectQsComponent(url,component){return url.replace(/(\?.*?)?(#|$)/,function(whole,qs,hash){return(qs?qs+'&':'?')+component+hash;});}
var main=core.createPlugin({eventSourceDefs:[eventSourceDef]});exports.default=main;Object.defineProperty(exports,'__esModule',{value:true});}));