<?php
require_once("include/dbcommon.php"); // DataBase PHPRunner

if (isset($_SESSION['grupo'])) {
    $grupo = $_SESSION['grupo']; // Grupo que estamos accediendo
} elseif (isset($_SESSION['jefe'])) {
		$jefe = $_SESSION['jefe'];
}
	else {
		$user_idusuario = $_SESSION["user_idusuario"]; // Usuario que estamos accediendo
}

// Require our Event class and datetime utilities
require 'fullcalendar/php/utils.php';

// Short-circuit if the client did not give us a date range.
if (!isset($_GET['start']) || !isset($_GET['end'])) {
  die("Please provide a date range.");
}

// Parse the start/end parameters.
// These are assumed to be ISO8601 strings with no time nor timeZone, like "2013-12-29".
// Since no timeZone will be present, they will parsed as UTC.
$range_start = parseDateTime($_GET['start']);
$range_end = parseDateTime($_GET['end']);

// Parse the timeZone parameter if it is present.

$time_zone ='UTC';
if (isset($_GET['timeZone'])) {
//   $time_zone = new DateTimeZone($_GET['timeZone']);
}


$start = substr($_GET['start'],0,10).' 00:00:00'; 
$end   = substr($_GET['end']  ,0,10).' 00:00:00';
$now   = date('Y-m-d H:i:s', strtotime(now(). ' +2 hour')); // now() + 1
if ( $start < $now ) { //  Minimum date of the moment
//		$start = $now;
		}
$language = 'es';

if (isset($grupo)) { // Accediendo por Grupo
$sql = "
SELECT
grupo_trabajo.Titulo,
peticion.idpeticion,
peticion.usuario_idusuario,
peticion.FechaInicio,
peticion.FechaFin,
peticion.DiasNaturales,
peticion.DiasLaborables,
peticion.DiasFinSemana,
peticion.DiasFiesta,
usuario.Color,
usuario.NombreyApellido,
peticion.Status
FROM grupo_trabajo
JOIN usuario_grupo ON (grupo_trabajo.idgrupo_trabajo = usuario_grupo.grupo_trabajo_idgrupo_trabajo)
JOIN usuario ON ( usuario_grupo.usuario_idusuario = usuario.idusuario)
JOIN peticion ON ( peticion.usuario_idusuario = usuario_grupo.usuario_idusuario)
WHERE grupo_trabajo.Titulo = '$grupo' and
peticion.FechaFin >= '$start' and peticion.FechaInicio <= '$end' 
";
}
if (isset($user_idusuario)) { // Accediendo por Usuario
$sql = "
SELECT
'Empresa' Titulo,
 peticion.idpeticion,
 peticion.usuario_idusuario,
 peticion.FechaInicio,
 peticion.FechaFin,
 peticion.DiasNaturales,
 peticion.DiasLaborables,
 peticion.DiasFinSemana,
 peticion.DiasFiesta,
 usuario.Color,
 usuario.NombreyApellido,
 peticion.Status

FROM peticion
JOIN usuario ON (peticion.usuario_idusuario = usuario.idusuario)
 WHERE peticion.usuario_idusuario =$user_idusuario and
  peticion.FechaFin >= '$start' and peticion.FechaInicio <= '$end' 
  ";
  }
if (isset($jefe)) { // Accediendo por Jefe
$sql = "
SELECT
'Empresa' Titulo,
usuario.idusuario,
usuario.NombreyApellido,
usuario.Color,
usuario.Jefe_id,
peticion.idpeticion,
peticion.usuario_idusuario,
peticion.FechaInicio,
peticion.FechaFin,
peticion.Status,
periodo.idperiodo,
periodo.Abierto
FROM usuario usuario
JOIN peticion ON (usuario.idusuario = peticion.usuario_idusuario)
JOIN periodo ON (peticion.periodo_idperiodo = periodo.idperiodo and periodo.Abierto = 1)
 WHERE usuario.Jefe_id = $jefe and
  peticion.FechaFin >= '$start' and peticion.FechaInicio <= '$end' 
  ";
  }

$rs = DB::Query($sql);
// Accumulate an output array of event data arrays.
$output_arrays = array();

while( $data = $rs->fetchAssoc() ){
$color = $data['Color'];
if ( $data['Status'] == '0' ) { 
	$color = 'black'; 
}
$output_arrays[] = array(
    'id'=>$data['idpeticion'],
    'title'=>date_format(date_create($data['FechaInicio']),"d/m/Y").' - '.date_format(date_create($data['FechaFin']),"d/m/Y").' - '.$data['NombreyApellido'],
    'resourceId'=>$data['usuario_idusuario'],
    'color'=>$color,
    'start'=>$data['FechaInicio'],
    'end'=>date('Y-m-d', strtotime($data['FechaFin']. ' +1 day')),
    'description'=>' ');
    }


// Send JSON to the client.
// $str = json_encode($output_arrays);
echo json_encode($output_arrays);

?>