<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

require_once("../include/dbcommon.php");

// Load the PHPWord library classes
require_once __DIR__ . '/phpword_1.0.0/autoload.php'; 
use PhpOffice\PhpWord\Element\TextRun;
use PhpOffice\PhpWord\Element\Section;
use PhpOffice\PhpWord\SimpleType\DocProtect;

// ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$id= $_SESSION['id'] ; // identificación de la Petición

$decimal = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL); 
$decimal->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 2);
$decimal->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 2); // by default some locales got max 2 fraction digits
$entero = new \NumberFormatter("es-ES", \NumberFormatter::DECIMAL);
$entero->setAttribute(\NumberFormatter::MIN_FRACTION_DIGITS, 0);
$entero->setAttribute(\NumberFormatter::MAX_FRACTION_DIGITS, 0); 

// Template processor instance creation
$template_word = __DIR__.'/TemplatePetition.docx';

\PhpOffice\PhpWord\Settings::setOutputEscapingEnabled(true);

$templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor($template_word);

// -------------------- ^ cabecera necesaria para las plantillas de Word ------------------
$sql="SELECT id, name, date, expose, request FROM html_word WHERE id = $id";
$resql=DB::Query($sql);
$data=$resql->fetchAssoc();

$templateProcessor->setValue('name', $data['name']);  

// Date Local completed
$myDate = DateTime::createFromFormat('Y-m-d', $data['date']);
$formatter = new IntlDateFormatter('es_ES', IntlDateFormatter::LONG, IntlDateFormatter::LONG);
$formatter->setPattern("d 'de' MMMM 'de' yyyy");
$myDate = $formatter->format($myDate);
$templateProcessor->setValue('date', $myDate);

// ------------------------------HTML "expose" -------------------------------------
$phpWord = new \PhpOffice\PhpWord\PhpWord();
$section = $phpWord->addSection();
\PhpOffice\PhpWord\Shared\Html::addHtml($section, $data['expose'], false, false);
$elements_ar = $section->getElements();
$count = count($elements_ar); // Número de elementos generados por el HTML
$templateProcessor->cloneBlock('BEXPOSE',$count, true, true);

for ($i = 1; $i <= $count; $i++) {
    $tag = 'expose#'.$i;
    $templateProcessor->setComplexBlock($tag , $elements_ar[$i-1]);
}
$section2 = $phpWord->addSection();
// ------------------------------HTML "request" -------------------------------------
\PhpOffice\PhpWord\Shared\Html::addHtml($section2, $data['request'], false, false);
$elements_ar = $section2->getElements();
$count = count($elements_ar); // Número de elementos generados por el HTML
$templateProcessor->cloneBlock('BREQUEST',$count, true, true);

for ($i = 1; $i <= $count; $i++) {
    $tag = 'request#'.$i;
    $templateProcessor->setComplexBlock($tag , $elements_ar[$i-1]);
}


$temp_file = tempnam(sys_get_temp_dir(), 'Word');
$templateProcessor->saveAS($temp_file);

// ------------------ Operation with file result -------------------------------------------
$document = file_get_contents($temp_file);
unlink($temp_file);  // delete file tmp
header("Content-Disposition: attachment; filename= petition.docx");
header('Content-Type: application/docx');
echo $document;
