<?php
// use setasign\Fpdi\Fpdi;
use setasign\Fpdi\Tcpdf\Fpdi;

require_once __DIR__ . '/fpdi_2.3.7/autoload.php';

require_once __DIR__ . '/PDF_functions.php';   // Function Print into PDF

// initiate FPDI
$pdf = new Fpdi();

// Very important
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set the source file
$template_pdf = __DIR__.'/TemplateInvoice.pdf';
$pdf->setSourceFile($template_pdf);
// import page 1
$tplIdx = $pdf->importPage(1);
// get the size of the imported page
$size = $pdf->getTemplateSize($tplIdx);
// add a page with the same orientation and size
$pdf->AddPage($size['orientation'], $size);
// use the imported page
$pdf->useTemplate($tplIdx);

// Obtain measures from the page for the transformation of the Points
$pdf->SetXY(1, 1);
$wPt = 595.28; //  Measures in points of the page
$w   = $pdf->GetPageWidth();
$hPt = 841.89; //  Measures in points of the page
$h   = $pdf->GetPageHeight();
$coef_x = $wPt/$w; // X axis transformation coefficient
$coef_y = $hPt/$h; // Y axis transformation coefficient

// -----------------------------------------------Recover invoice data-------------------------------------------------------------------------------------------------------
$idfactura= $_SESSION['idfactura'] ; // invoice identification to obtain

$sql="SELECT Nif, NombreRazonSocial, Domicilio, RestoDomicilio, FechaFactura, TotalFactura FROM factura where idfactura = $idfactura";
$resql=DB::Query($sql);
$data = $resql->fetchAssoc() ;

// Variables on different parts of document

print_pdf(322, 81, '#'.$idfactura, 'char', 0 , 'L', '', 'helvetica', 16, "247, 172, 8", 0 ); // Number invoce
print_pdf(454, 81,$data['FechaFactura'], 'date', 0 , 'L', '', 'helvetica', 16, "247, 172, 8", 0 ); //  Date invoce
print_pdf(91,113,$data['Nif'], 'char', 0 , 'L', 'B', 'helvetica', 10, "0,0,0", 0 ); //  NIF
print_pdf(91,127,$data['NombreRazonSocial'], 'char', 0 , 'L', 'B', 'helvetica', 10, "68,68,68", 0 ); // Nombre
// $string = iconv("UTF-8", "ISO-8859-1//TRANSLIT", $data['Domicilio']); // Convert UTf8
print_pdf(91,141,$data['Domicilio'], 'char', 0 , 'L', '', 'helvetica', 10, "68,68,68", 0 ); // Domicilio
print_pdf(91,154, $data['RestoDomicilio'], 'char', 0 , 'L', '', 'helvetica', 10, "68,68,68", 0 ); // Resto Domicilio
$page_number = 1;
print_pdf(483, 156, $page_number,'number', 0 , 'R', 'B', 'helvetica', 12, "0,0,0", 0 ); // Number page

print_pdf(531,649,$data['TotalFactura'], 'number', 2 , 'R', 'B', 'helvetica', 10, "0,0,0", 0 ); // TotalFactura
print_pdf(531,679,$data['TotalFactura'], 'number', 2 , 'R', 'B', 'helvetica', 10, "0,0,0", 0 ); // TotalFactura

// --------------------------------------------------------------
// Cálculo de páginas de la factura
$sql="SELECT count(*) total_records   FROM linea_factura where factura_idfactura= $idfactura ";
$resql=DB::Query($sql);
$data3 = $resql->fetchAssoc() ;
$total_records = $data3['total_records'];
if ( $total_records < 32 ) {
	$total_pages = 1;
} else {
	$total_pages = intdiv(($total_records - 31),39);
	$total_pages += 1;
	if ((($total_records - 31) % 39) > 0 ) {
		$total_pages += 1;
	}
}

print_pdf(165,663, $total_pages, 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Page
print_pdf(260, 663, $total_records, 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Record

// ------------------------------------------------------------
// Insert image
$pdf->Image(__DIR__.'/QR_prueba.png' , 180 , 5, 20 , 20,'PNG', 'https://fhumanes.com/');

// --------------------------------------------------------------
$sql="SELECT producto_idproducto, Nombre, Precio, Cantidad, Valor   FROM linea_factura where factura_idfactura= $idfactura ";
$rsSql=DB::Query($sql);
$countLines=0;
$num_record = 1;
while( $data2 = $rsSql->fetchAssoc() ){
	if ( $num_record < 32 ) {

		print_pdf(81, 200+($countLines*14.55), $num_record, 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Record		
		print_pdf(139, 200+($countLines*14.55),$data2['producto_idproducto'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Id Producto
		print_pdf(145.5, 200+($countLines*14.55),$data2['Nombre'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Nombre
		print_pdf(401, 200+($countLines*14.55),$data2['Precio'], 'number', 2 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Precio
		print_pdf(460, 200+($countLines*14.55),$data2['Cantidad'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Cantidad 
		print_pdf(533, 200+($countLines*14.55),$data2['Valor'], 'number', 2 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Valor	
		$countLines=$countLines+1;
		$num_record += 1;
	} else {
	$new_record = ($num_record - 32) % 39 ; // para control de nueva página
	if ($new_record == 0 ) { // Nueva página 
		$countLines=0;
		$page_number += 1;
		// import page 1
		$tplIdx = $pdf->importPage(2);
		// get the size of the imported page
		$size = $pdf->getTemplateSize($tplIdx);
		// add a page with the same orientation and size
		$pdf->AddPage($size['orientation'], $size);
		// use the imported page
		$pdf->useTemplate($tplIdx);
		print_pdf(496, 108, $page_number,'number', 0 , 'R', 'B', 'helvetica', 12, "0,0,0", 0 ); // Number page
	}

	print_pdf(81, 151+($countLines*14.55), $num_record, 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Record		
	print_pdf(139, 151+($countLines*14.55),$data2['producto_idproducto'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Id Producto
	print_pdf(145.5, 151+($countLines*14.55),$data2['Nombre'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Nombre
	print_pdf(401, 151+($countLines*14.55),$data2['Precio'], 'number', 2 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Precio
	print_pdf(460, 151+($countLines*14.55),$data2['Cantidad'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Cantidad 
	print_pdf(533, 151+($countLines*14.55),$data2['Valor'], 'number', 2 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  //  Valor	
	$countLines=$countLines+1;
	$num_record += 1;

	}
}

// -----------------------------------------------------------------------------------------
//  adding the second page of the template
$tplIdx = $pdf->importPage(3);
// get the size of the imported page
$size = $pdf->getTemplateSize($tplIdx);
// add a page with the same orientation and size
$pdf->AddPage($size['orientation'], $size);
// use the imported page
// $pdf->useTemplate($tplIdx);
$pdf->useImportedPage($tplIdx);

// ---------------------------------------------------------
// $pdf->Output('I','Factura.pdf');
$pdf->Output('Factura.pdf', 'I');
// $pdf->Output();
/*
// --------------------  foot to save the new PDF document ------------------
$temp_file = tempnam(sys_get_temp_dir(), 'PDF');
$pdf->Output('F',$temp_file);

// ------------------ Operation with file result -------------------------------------------
$documento = file_get_contents($temp_file);
unlink($temp_file);  // delete file tmp
header("Content-Disposition: attachment; filename= factura.pdf");
header('Content-Type: application/pdf');
echo $documento;
*/

?>