<?php
/*
Param:

Type = char | number | integer | date | dateTime | time | dateLong | boolean | memo
NumberDecimal = 0
Align = L left | R right | C center
FontStyle = 'B' | 'I' | 'U' | ''
Font = 'helvetica'
FontSize = 10
ColorRGB = "0,0,0"
RightMargin = 0  Especial fields MEMO

*/
function print_pdf($point_x = 1, $point_y = 1, $value = 0, $type = 'char', $numberDecimal = 0 ,
                   $align = 'L', $fontStyle = '', $font = 'helvetica', $fontSize = 11, $colorRGB = "0,0,0", $rightMargin = 0 )
{
    $pdf = $GLOBALS['pdf'];
    $coef_x = $GLOBALS['coef_x'];
    $coef_y = $GLOBALS['coef_y'];
    $wPt  = $GLOBALS['wPt'];
    /*
    $numeric_symbol_of_thousands = $GLOBALS['numeric_symbol_of_thousands'];
    $numeric_decimal_symbol = $GLOBALS['numeric_decimal_symbol'];
    $date_format = $GLOBALS['date_format'];
    $date_and_time_format = $GLOBALS['date_and_time_format'];
    $time_format = $GLOBALS['time_format'];
    $long_Date_Format = $GLOBALS['long_Date_Format'];
    */

    date_default_timezone_set( $GLOBALS['date_default_timezone_set'] );
    setlocale(LC_TIME, $GLOBALS['setlocale_LC_TIME']);

    if ( $align == 'R' ) {  
				if ($type == 'number' || $type == 'integer') {
        $rightMargin =  $wPt - $point_x ;  // Obtain the distance from the right margin from the osition of the field.
			}
    }

    $pdf->SetXY($point_x/$coef_x, $point_y/$coef_y);             // Positioning on the page
    $pdf->SetMargins($point_x/$coef_x,5,$rightMargin/$coef_x);   // For fields MEMO
    $pdf->SetFont($font,$fontStyle,$fontSize);                   //  Font, type and size
    $FontColor = explode(",", $colorRGB);                      
    $pdf->SetTextColor($FontColor[0],$FontColor[1],$FontColor[2]); // Color in R, G, B

    switch ($type) {
    case 'char': // Char
        $pdf->Cell(0,0,$value,0,1,$align);
        break;
    case 'number': // Num
        $value = number_format($value, $numberDecimal ,$GLOBALS['numeric_decimal_symbol'] ,$GLOBALS['numeric_symbol_of_thousands']);
        $pdf->Cell(0,0,$value,0,1,$align);
         break;
    case 'integer': // Integer
        $pdf->Cell(0,0,$value,0,1,$align);
         break;
    case 'date': // Date
        $date = new DateTimeImmutable($value);
        $value = $date->format($GLOBALS['date_format']);
        $pdf->Cell(0,0,$value,0,1,$align);
        break;
     case 'time': // Time
        $date = new DateTimeImmutable($value);
        $value = $date->format($GLOBALS['time_format']);
        $pdf->Cell(0,0,$value,0,1,$align);
        break;
    case 'dateTime': // DateTime
        $date = new DateTimeImmutable($value);
        $value = $date->format($GLOBALS['date_and_time_format']);
        $pdf->Cell(0,0,$value,0,1,$align);
        break;   
    case 'dateLong': // Date Long
        $date = new DateTimeImmutable($value);
        $value = $date->format($GLOBALS['long_Date_Format']);
        $pdf->Cell(0,0,$value,0,1,$align);
        break;   
    case 'boolean': // Boolean
        $pdf->SetFont('ZapfDingbats',$fontStyle,$fontSize);     //  Font, type and size
        if ($value == 1) {$value = '4';} else {$value = '';}    // 'l' Punto negro
        $pdf->Cell(0,0,$value,0,1,$align);
        break;   
    case 'memo': // Memo
        $pdf->Write(5, $value);
        break;   
    default:
        $pdf->Cell(0,0,$value,0,1,$align);
    }
}
