<?php
// Required by PHPRunner (security)
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");

// use setasign\Fpdi\Fpdi;
use setasign\Fpdi\Tcpdf\Fpdi;

require_once __DIR__ . '/../fpdi_2.3.7/autoload.php';

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../PDF_functions.php';   // Function Print into PDF

// initiate FPDI
$pdf = new Fpdi();

// Very important
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set the source file
$template_pdf = __DIR__.'/template.pdf';
$pdf->setSourceFile($template_pdf);
// import page 1
$tplIdx = $pdf->importPage(1);
// get the size of the imported page
$size = $pdf->getTemplateSize($tplIdx);
// add a page with the same orientation and size
// $pdf->AddPage($size['orientation'], $size);
// use the imported page
// $pdf->useTemplate($tplIdx);

// Obtain measures from the page for the transformation of the Points
$pdf->SetXY(1, 1);
$wPt = 595.20; //  Measures in points of the page
$w   = $pdf->GetPageWidth();
$hPt = 841.80; //  Measures in points of the page
$h   = $pdf->GetPageHeight();
$coef_x = $wPt/$w; // X axis transformation coefficient
$coef_y = $hPt/$h; // Y axis transformation coefficient

// -----------------------------------------------------------------------------------------------------------------------------------------------------


$sql = 
"SELECT mun.`idrp_municipio`, mun.`CodigoProvincia`, mun.`CodigoMunicipio`, mun.`NombreMunicipio`,
       prov.`NombreProvincia`
FROM rp_municipio mun
JOIN rp_provincia prov on (mun.`CodigoProvincia` = prov.`CodigoProvincia`)
ORDER BY mun.`CodigoProvincia`, mun.`CodigoMunicipio` ";
$rs = DB::Query($sql);
$dateNow = date("Y-m-d");
$countLines = 0;   // Diferent to '0' for init Report
$countPage = 0;
$numLinesPage =44;
$CodigoProvinca = '';  // Control change key
while ($data = $rs->fetchAssoc()) {

// Variables on different parts of document
if ($countLines == $numLinesPage || $CodigoProvincia <> $data['CodigoProvincia'] ) { // The End Record in Page
	$countLines = 0;
	// import page 1
	$tplIdx = $pdf->importPage(1);
	// get the size of the imported page
	$size = $pdf->getTemplateSize($tplIdx);
	// add a page with the same orientation and size
	$pdf->AddPage($size['orientation'], $size);
	// use the imported page
	$pdf->useTemplate($tplIdx);
}
if ($countLines == 0 ) { // Initialitation page
	$countPage += 1;
	print_pdf(404,77.14, $dateNow, 'date', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Date
	print_pdf(442,767, $countPage, 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Page
	$CodigoProvincia = $data['CodigoProvincia'];
  print_pdf(176.5,95, $data['CodigoProvincia'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  CodigoProvincia
	print_pdf(197,95, '-', 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  
	print_pdf(210,95, $data['NombreProvincia'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  NombreProvincia
}
print_pdf(96, 126+($countLines*14.5), $data['idrp_municipio'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // id		
print_pdf(154, 126+($countLines*14.5),$data['CodigoMunicipio'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // CodigoMunicipio
print_pdf(190, 126+($countLines*14.5),$data['NombreMunicipio'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //NombreMunicipio
	
$countLines += 1;
}


// ------------------------------------------------------------
// Insert image
// $pdf->Image(__DIR__.'/QR_prueba.png' , 180 , 5, 20 , 20,'PNG', 'https://fhumanes.com/');

// --------------------------------------------------------------

$pdf->Output('Listado de Municipios.pdf', 'I');

?>