<?php
// Required by PHPRunner (security)
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");

// use setasign\Fpdi\Fpdi;
use setasign\Fpdi\Tcpdf\Fpdi;

require_once __DIR__ . '/../fpdi_2.3.7/autoload.php';

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../PDF_functions.php';   // Function Print into PDF

require __DIR__.'/graphic.php';

// initiate FPDI
$pdf = new Fpdi();

// Very important
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set the source file
$template_pdf = __DIR__.'/template.pdf';
$pdf->setSourceFile($template_pdf);
// import page 1
$tplIdx = $pdf->importPage(1);
// get the size of the imported page
$size = $pdf->getTemplateSize($tplIdx);
// add a page with the same orientation and size
// $pdf->AddPage($size['orientation'], $size);
// use the imported page
// $pdf->useTemplate($tplIdx);

// Obtain measures from the page for the transformation of the Points
$pdf->SetXY(1, 1);
$wPt = 595.20; //  Measures in points of the page
$w   = $pdf->GetPageWidth();
$hPt = 841.80; //  Measures in points of the page
$h   = $pdf->GetPageHeight();
$coef_x = $wPt/$w; // X axis transformation coefficient
$coef_y = $hPt/$h; // Y axis transformation coefficient

// -----------------------------------------------------------------------------------------------------------------------------------------------------


$sql = 
"SELECT idrp_provincia, rp_provincia.CodigoProvincia, NombreProvincia, COUNT(*) municipios
FROM rp_provincia left JOIN  rp_municipio on ( rp_provincia.CodigoProvincia = rp_municipio.CodigoProvincia )
Group by 1,2,3
Order By 4 desc";
$rs = DB::Query($sql);
$dateNow = date("Y-m-d");
$countLines = 0;   // Diferent to '0' for init Report
$countPage = 0;
$numLinesPage1 = 24;
$numLinesPage2 = 50;
while ($data = $rs->fetchAssoc()) {

// Variables on different parts of document
if (($countLines == $numLinesPage1 && $countPage == 1) || ($countLines == $numLinesPage2 && $countPage <> 1)   || $countLines == 0 ) { // The End Record in Page
	$countLines = 0;
	if ($countPage == 0 ) {
		// import page 1
		$tplIdx = $pdf->importPage(1);
	} else {
		// import page 2
		$tplIdx = $pdf->importPage(2);		
	}
	// get the size of the imported page
	$size = $pdf->getTemplateSize($tplIdx);
	// add a page with the same orientation and size
	$pdf->AddPage($size['orientation'], $size);
	// use the imported page
	$pdf->useTemplate($tplIdx);
}
if ($countLines == 0 ) { // Initialitation page
	$countPage += 1;
	print_pdf(440,76, $dateNow, 'date', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Date
	print_pdf(453,772, $countPage, 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Page
	if ($countPage == 1) {
		// Insert image
		$pdf->Image($filePNG ,80/$coef_x ,110/$coef_y, 133.33 , 100 ,'PNG',null, 'L', true);
		unlink($filePNG); // Delete file
	}
}
if ($countPage == 1) {
	print_pdf(106, 425+($countLines*14.458),$data['idrp_provincia'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // id		
	print_pdf(162, 425+($countLines*14.458),$data['CodigoProvincia'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // CodigoMunicipio
	print_pdf(180, 425+($countLines*14.458),$data['NombreProvincia'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //NombreMunicipio
	print_pdf(509, 425+($countLines*14.458),$data['municipios'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // CodigoMunicipio

} else {
	print_pdf(106, 106+($countLines*14.458),$data['idrp_provincia'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // id		
	print_pdf(162, 106+($countLines*14.458),$data['CodigoProvincia'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // CodigoMunicipio
	print_pdf(180, 106+($countLines*14.458),$data['NombreProvincia'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //NombreMunicipio
	print_pdf(509, 106+($countLines*14.458),$data['municipios'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // CodigoMunicipio
}
$countLines += 1;
}


// ------------------------------------------------------------
// Insert image
// $pdf->Image(__DIR__.'/QR_prueba.png' , 180 , 5, 20 , 20,'PNG', 'https://fhumanes.com/');

// --------------------------------------------------------------

$pdf->Output('Listado de Municipios.pdf', 'I');

?>