<?php
// Required by PHPRunner (security)
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("../../include/dbcommon.php");
// use setasign\Fpdi\Fpdi;
use setasign\Fpdi\Tcpdf\Fpdi;

require_once __DIR__ . '/../fpdi_2.3.7/autoload.php';

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../PDF_functions.php';   // Function Print into PDF

// initiate FPDI
$pdf = new Fpdi();

// Very important
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set the source file
$template_pdf = __DIR__.'/template.pdf';
$pdf->setSourceFile($template_pdf);
// import page 1
$tplIdx = $pdf->importPage(1);
// get the size of the imported page
$size = $pdf->getTemplateSize($tplIdx);
// add a page with the same orientation and size
$pdf->AddPage($size['orientation'], $size);
// use the imported page
$pdf->useTemplate($tplIdx);

// Obtain measures from the page for the transformation of the Points
$pdf->SetXY(1, 1);
$wPt = 613.32; //  Measures in points of the page
$w   = $pdf->GetPageWidth();
$hPt = 867.60; //  Measures in points of the page
$h   = $pdf->GetPageHeight();
$coef_x = $wPt/$w; // X axis transformation coefficient
$coef_y = $hPt/$h; // Y axis transformation coefficient

// -----------------------------------------------------------------------------------------------------------------------------------------------------


$sql = "SELECT idrp_pais, CodigoPais, IndicadorBaja, NombrePais FROM rp_pais ORDER BY CodigoPais";
$rs = DB::Query($sql);
$dateNow = date("Y-m-d");
$countLines = 0;
$countPage = 0;
$numLinesPage =46;
while ($data = $rs->fetchAssoc()) {

// Variables on different parts of document
if ($countLines == $numLinesPage) { // The End Record in Page
	$countLines = 0;
	// import page 1
	$tplIdx = $pdf->importPage(1);
	// get the size of the imported page
	$size = $pdf->getTemplateSize($tplIdx);
	// add a page with the same orientation and size
	$pdf->AddPage($size['orientation'], $size);
	// use the imported page
	$pdf->useTemplate($tplIdx);
}
if ($countLines == 0) { // Initialitation page
	$countPage += 1;
	print_pdf(469,79.8, $dateNow, 'date', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Date
	print_pdf(500,776, $countPage, 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //  Nunber Page
}
print_pdf(105, 108+($countLines*14.478), $data['idrp_pais'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // id		
print_pdf(167, 108+($countLines*14.478),$data['CodigoPais'], 'number', 0 , 'R', '', 'helvetica', 10, "0,0,0", 0 );  // CodigoPais
print_pdf(181, 108+($countLines*14.478),$data['NombrePais'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  //NombrePais
print_pdf(521, 108+($countLines*14.478),$data['IndicadorBaja'], 'char', 0 , 'L', '', 'helvetica', 10, "0,0,0", 0 );  // IndicadorBaja
	
$countLines += 1;
}


// ------------------------------------------------------------
// Insert image
// $pdf->Image(__DIR__.'/QR_prueba.png' , 180 , 5, 20 , 20,'PNG', 'https://fhumanes.com/');

// --------------------------------------------------------------

$pdf->Output('Listado de Países.pdf', 'I');

?>