<?php
require_once("include/dbcommon.php"); // DataBase PHPRunner


// Require our Event class and datetime utilities
require 'fullcalendar-6.1.8/php/utils.php';

// Short-circuit if the client did not give us a date range.
if (!isset($_GET['start']) || !isset($_GET['end']) || !isset($_GET['id_user'])) {
  die("Please provide a date range.");
}

$id_user = $_GET['id_user']; // id of User

// Parse the start/end parameters.
// These are assumed to be ISO8601 strings with no time nor timeZone, like "2013-12-29".
// Since no timeZone will be present, they will parsed as UTC.
$range_start = parseDateTime($_GET['start']);
$range_end = parseDateTime($_GET['end']);

// Parse the timeZone parameter if it is present.

$time_zone ='UTC';
if (isset($_GET['timeZone'])) {
//   $time_zone = new DateTimeZone($_GET['timeZone']);
}


$start = substr($_GET['start'],0,10).' 00:00:00'; 
$end   = substr($_GET['end']  ,0,10).' 00:00:00';
$now   = date('Y-m-d H:i:s', strtotime(now(). ' +2 hour')); // now() + 1
if ( $start < $now ) { //  Minimum date of the moment
    //$start = $now;
}
$language = 'es';

$sql = "
SELECT
u.`id_incidente_usuario`,
u.`login`,
u.`nombre_apellidos`,
c.`id_incidente_caso`,
c.`incidente_usuario_id`,
c.`incidente_tipo_id`,
c.`fechaDesde`,
c.`fechaHasta`,
c.`titulo`,
c.`diasLaborables`,
c.`diasFinSemana`,
t.`id_incidente_tipo`,
t.`titulo` tipo,
t.`color`
FROM incidente_usuario u
join incidente_caso c on (u.`id_incidente_usuario` = c.`incidente_usuario_id`)
join incidente_tipo t on (c.`incidente_tipo_id` = t.`id_incidente_tipo`)
where u.`id_incidente_usuario` = $id_user and
c.`fechaHasta` >= '$start' and c.`fechaDesde` <= '$end'
";

$rs = DB::Query($sql);
// Accumulate an output array of event data arrays.
$output_arrays = array();

while( $data = $rs->fetchAssoc() ){
$color = $data['color'];

$output_arrays[] = array(
    'id'=>$data['id_incidente_caso'],
    'title'=>$data['tipo'].' - '.date_format(date_create($data['fechaDesde']),"d/m/Y").' - '.date_format(date_create($data['fechaHasta']),"d/m/Y"),
    // 'resourceId'=>$data['usuario_idusuario'],
    'color'=>$color,
    'start'=>$data['fechaDesde'],
    'end'=>date('Y-m-d', strtotime($data['fechaHasta']. ' +1 day')),
    'description'=>'<B>'.$data['tipo'].'</B><BR>'.date_format(date_create($data['fechaDesde']),"d/m/Y").' - '.date_format(date_create($data['fechaHasta']),"d/m/Y")
			);
}


// Send JSON to the client.
// $str = json_encode($output_arrays);
echo json_encode($output_arrays);

?>

