<?php

$id_user = $_GET['masterkey1']; // ID of User 

$html = <<<EOT

<script src='fullcalendar-6.1.8/dist/index.global.min.js'></script>
<script src='fullcalendar-6.1.8/packages/core/locales-all.global.min.js'></script>

<script src='fullcalendar-6.1.8/dist/popper.min.js'></script>
<script src="fullcalendar-6.1.8/dist/tooltip.min.js"></script>


<style>

  #calendar {
    max-width: 1200px;
    margin: 30px auto;
    font-family: Arial, Helvetica Neue, Helvetica, sans-serif;
    font-size: 14px;
  }

/*
i wish this required CSS was better documented :(
https://github.com/FezVrasta/popper.js/issues/674
derived from this CSS on this page: https://popper.js.org/tooltip-examples.html
*/

.popper,
.tooltip {
  position: absolute;
  z-index: 9999;
  background: #3684EE;
  color: black;
  width: 200px;
  border-radius: 3px;
  box-shadow: 0 0 2px rgba(0,0,0,0.5);
  padding: 10px;
  text-align: center;
  opacity: 1;
}
.tooltip-inner {
  background-color: transparent;
}
.style5 .tooltip {
  background: #1E252B;
  color: #FFFFFF;
  max-width: 200px;
  width: auto;
  font-size: .8rem;
  padding: .5em 1em;
}
.popper .popper__arrow,
.tooltip .tooltip-arrow {
  width: 0;
  height: 0;
  border-style: solid;
  position: absolute;
  margin: 5px;
}

.tooltip .tooltip-arrow,
.popper .popper__arrow {
  border-color: #3684EE;
}
.style5 .tooltip .tooltip-arrow {
  border-color: #3684EE;
}
.popper[x-placement^="top"],
.tooltip[x-placement^="top"] {
  margin-bottom: 5px;
}
.popper[x-placement^="top"] .popper__arrow,
.tooltip[x-placement^="top"] .tooltip-arrow {
  border-width: 5px 5px 0 5px;
  border-left-color: transparent;
  border-right-color: transparent;
  border-bottom-color: transparent;
  bottom: -5px;
  left: calc(50% - 5px);
  margin-top: 0;
  margin-bottom: 0;
}
.popper[x-placement^="bottom"],
.tooltip[x-placement^="bottom"] {
  margin-top: 5px;
}
.tooltip[x-placement^="bottom"] .tooltip-arrow,
.popper[x-placement^="bottom"] .popper__arrow {
  border-width: 0 5px 5px 5px;
  border-left-color: transparent;
  border-right-color: transparent;
  border-top-color: transparent;
  top: -5px;
  left: calc(50% - 5px);
  margin-top: 0;
  margin-bottom: 0;
}
.tooltip[x-placement^="right"],
.popper[x-placement^="right"] {
  margin-left: 5px;
}
.popper[x-placement^="right"] .popper__arrow,
.tooltip[x-placement^="right"] .tooltip-arrow {
  border-width: 5px 5px 5px 0;
  border-left-color: transparent;
  border-top-color: transparent;
  border-bottom-color: transparent;
  left: -5px;
  top: calc(50% - 5px);
  margin-left: 0;
  margin-right: 0;
}
.popper[x-placement^="left"],
.tooltip[x-placement^="left"] {
  margin-right: 5px;
}
.popper[x-placement^="left"] .popper__arrow,
.tooltip[x-placement^="left"] .tooltip-arrow {
  border-width: 5px 0 5px 5px;
  border-top-color: transparent;
  border-right-color: transparent;
  border-bottom-color: transparent;
  right: -5px;
  top: calc(50% - 5px);
  margin-left: 0;
  margin-right: 0;
}

</style>

  <div id='calendar'></div>

<script>
  var initialLocaleCode = 'es';
  
  document.addEventListener('DOMContentLoaded', function() {
  var calendarEl = document.getElementById('calendar');

  var calendar = new FullCalendar.Calendar(calendarEl, {
      timeZone: 'UTC+1', // the default 'local' (unnecessary to specify)
      locale: initialLocaleCode,
      height: 'auto',
		  // navLinks: true, // can click day/week names to navigate views

		  headerToolbar: { center: 'dayGridMonth Trimestre multiMonthYear' }, // buttons for switching between views
		  initialView: 'Trimestre',
		  views: {
			 Trimestre: {
				type: 'multiMonth',
				duration: { months: 3 }
			 }
		  },
      editable: false,
      multiMonthMinWidth: 50,
      multiMonthMaxColumns: 3,
      weekends: true,
      dayHeaders: true,
      firstDay: 1,
			 selectable: true,

			// ADD previus select Date
			select: function(info) {        
					console.log('Estoy en evento de Select: '+ info.startStr + ' to ' + info.endStr);
					var startDate = info.startStr;
					var  endDate = info.endStr;
					var title = 'Añadir nuevo Incidente';
					var url = "calendario_add.php?masterkey1=$id_user&page=add&mastertable=incidente_usuario&start="+startDate+"&end="+endDate;
					var header = '<h2 data-itemtype="add_header" data-itemid="add_header">'+ title+'</h2>' ;
					window.popup = Runner.displayPopup({
							  url: url,
							  width: 800,
							  height: 500,
							  header: header,
					// footer: '<a href="" onclick="window.win.close();return false;">Close window</a>',
					footer: '<a href="calendario_list.php?masterkey1=$id_user&page=list&mastertable=incidente_usuario" onclick="window.win.close();return false;">Close window and Reload page</a>',
					afterCreate: function(popup) {
						window.popup = popup;
					}
				});
      },

			 // Evenet managment the Tooltip
      eventDidMount: function(info) {
				console.log("estoy en evento de Tooltip");
        var tooltip = new Tooltip(info.el, {
/* title: info.event._def.title, */
					 title: info.event.extendedProps.description, 
/* title: "primera línea <BR> segunda línea", */
          placement: 'top',
					 html: true,
          trigger: 'hover',
          container: '#calendar'
        });
      },

			// Load data the Event
      events: { // you can also specify a plain string like 'json/events-for-resources.json'
      url: 'calendario_user_ajax.php?id_user=$id_user'},
      
			// Event for View and Edit
      eventClick: function(info) {
				console.log("estoy en evento de Click");
				var peticion = info.event.id;
				var title = info.event.title;
				var url = "calendario_view.php?editid1="+peticion;
				var header = '<h2 data-itemtype="view_header" data-itemid="view_header" data-pageid="10">'+'Petición: '+ title+'</h2>' ;
				window.popup = Runner.displayPopup({
                    url: url,
                    width: 800,
                    height: 500,
                    header: header,
				// footer: '<a href="" onclick="window.win.close();return false;">Close window</a>',
				footer: '<a href="calendario_list.php?masterkey1=$id_user&page=list&mastertable=incidente_usuario" onclick="window.win.close();return false;">Close window and Reload page</a>',
				afterCreate: function(popup) {
					window.popup = popup;
				}
		   }); 
			},

    });

    calendar.render();
  });

</script>

EOT;

echo $html;