<?php
require_once("include/dbcommon.php"); // DataBase PHPRunner


// Require our Event class and datetime utilities
require 'fullcalendar-6.1.8/php/utils.php';

// Short-circuit if the client did not give us a date range.
if (!isset($_GET['start']) || !isset($_GET['end']) ) {
  die("Please provide a date range.");
}

// Parse the start/end parameters.
// These are assumed to be ISO8601 strings with no time nor timeZone, like "2013-12-29".
// Since no timeZone will be present, they will parsed as UTC.
$range_start = parseDateTime($_GET['start']);
$range_end = parseDateTime($_GET['end']);

// Parse the timeZone parameter if it is present.

$time_zone ='UTC';
if (isset($_GET['timeZone'])) {
//   $time_zone = new DateTimeZone($_GET['timeZone']);
}


$start = substr($_GET['start'],0,10).' 00:00:00'; 
$end   = substr($_GET['end']  ,0,10).' 23:59:59';
$now   = date('Y-m-d H:i:s', strtotime(now(). ' +2 hour')); // now() + 1
if ( $start < $now ) { //  Minimum date of the moment
    //$start = $now;
}

$sql = "
SELECT
event.`id_event`,
event.`event_type_id`,
event.`title`,
event.`details`,
event.`startDate`,
event.`endDate`,
event.`enrolment`,
event_type.`color`
FROM event event
join event_type on (event_type.`id_event_type` = event.`event_type_id` )
where
-- event.`enrolment` = 1 and
event.`endDate` >= '$start' and event.`startDate` <= '$end'
";

$rs = DB::Query($sql);
// Accumulate an output array of event data arrays.
$output_arrays = array();

while( $data = $rs->fetchAssoc() ){
$color = $data['color'];

$output_arrays[] = array(
    'id'=>$data['id_event'],
    'title'=>$data['title'].' - '.date_format(date_create($data['startDate']),"m/d/Y H:i"),
    'color'=>$color,
    'start'=>date_format(date_create($data['startDate']),"Y-m-d"),
    'end'=>date('Y-m-d', strtotime($data['endDate']. ' +1 day')),
    'description'=>$data['details'],
			);
}


// Send JSON to the client.
// $str = json_encode($output_arrays);
echo json_encode($output_arrays);

?>

