<?php
/*
Variables passed by the Plugin:
$field_value .- Field what show screen
$DataValue  .- Valor del campoque se utiliza en el plugin
$javascript  .- File of Javascript of Anychart
$theme .- File of Theme of Anychart
$language  .- File Javscript of language
$decimalsCount .-  Parameter
$zeroFillDecimals .-  Parameter
$decimalPoint .-  Parameter
$groupsSeparator .-  Parameter
$license .- License of ANYCHART  for PHPRunner
$id_field .-  Field occurrence identification number used to identify the "container".
*/

global $conn;

$chartData = '';

$sql = "SELECT
master.`id_anychart_client`, master.`name`, master.`code`, master.`color`, sum(details.`amount`) amount
FROM anychart_client master
JOIN anychart_invoice details on (master.`id_anychart_client` = details.`anychart_client_id`)
GROUP BY 1,2,3,4
ORDER BY code";

$rs = DB::Query($sql);
while( $row = $rs->fetchAssoc() )
{
    $chartData.="['".$row['code']."',".$row['amount'].",'".$row['color']."','".$row['name']."'] \n,";
}

$chartData = substr($chartData, 0, -1);

$graphicDefinition= <<<EOT

var data = anychart.data.set([ 
 $chartData
  ]);

var seriesA = data.mapAs({'x':0, 'value':1, 'fill':2, 'title':3});

var chart = anychart.column();

// create a bar series and set the data
var series1 = chart.column(seriesA);
        
// turn on chart animation
chart.animation(true);

series1.normal().stroke({color: '#FFFFFF'}); // Sin border en las barras
        
// License, out logo
$license

// chart.padding([10, 10, 5, 10]);

// set label settings
chart
    .labels()
    .fontSize('9px')
    .enabled(true)
    .format('{%value}{type:number,decimalsCount:2}');
   
        
// set tooltip settings
chart
    .tooltip()
    .position('left-center')
    .anchor('left-center')
    .offsetX(5)
    .offsetY(0)
    .titleFormat('Code: {%X}')
    .format('Name: {%title}\\nTotal: {%value}');

 // set yAxis labels formatter
 chart.yAxis().labels().format('{%value}{type:number}');

// set titles for axises
// chart.xAxis().title('Candidaturas');
chart.xAxis().labels().fontSize(9).rotation(-30);
chart.yAxis().labels().fontSize(9);
chart.interactivity().hoverMode('by-x');
chart.tooltip().positionMode('point');
        
// set scale minimum
chart.yScale().minimum(0);
// chart.yScale().maximum(100);

// enable grids
chart.yGrid().stroke('#ddd');
chart.xGrid().stroke('#ddd');

chart.legend(false);

// Set event listener on the chart.
chart.listen("pointClick", function(e){
    var index = e.iterator.getIndex();
    console.log('Click en Item (index): '+ index);
    console.log('Click en Item : '+ e.iterator.get("x"));
    console.debug(e.iterator);
    $.ajax({  // Reload Details
		url: 'MyCode/details_snippet_ajax.php?code='+ e.iterator.get("x"),
		dataType: "html",
		type: "Get",
		data: { }
	 }).done(function (response) {
		  //alert('test');
		  $('div[data-itemid="dashboard_details"').html(response);
	 });
});
       
chart.container('container_$id_field');
// initiate chart drawing
chart.draw();
});

</script>
EOT;
$field_value .= $graphicDefinition;
?>
