<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
require_once("include/dbcommon.php");

// To ensure that only one process is validating if you have to run a batch
function single_execution( $semaphore, $process ) {
    $dir_path_base = __DIR__; 
    $path_semaphore = __DIR__."/semaphores/".$semaphore.".lock";
    $fp = fopen($path_semaphore, "r+");
    if ($fp == false ) { // file not found
        return array(false ,"The semaphore file does not exist!");
    }    
    if (!flock($fp, LOCK_EX|LOCK_NB, $blocked)) {
        if ($blocked) {    
            // another process holds the lock
            return array(false, "Couldn't get the lock! Other script in run!");     
        }
        else {
            // couldn't lock for another reason, e.g. no such file
            return array(false , "Error! Nothing done.");
        }
    }
    else {
        // lock obtained
        ftruncate($fp, 0);  // truncate file        
        // execute Process
        include ($process);    
        fflush($fp);            // flush output before releasing the lock
        flock($fp, LOCK_UN);    // release the lock        
        return array(true, "Process executed correctly");    
    }
}

$status_arr = single_execution( 'scheduler', 'My_Code/scheduler_process.php'); // Execute Process Scheduler single

custom_error(20,"Control Scheduler: ".$status_arr[1]); // To debug
