<?php
/*execute program and write all output to $out
terminate program if it runs more than XXX seconds */
function execute($cmd, $stdin=null, &$stdout, &$stderr, $timeout=false)
{
    $pipes = array();
    $process = proc_open(
        $cmd,
        array(array('pipe','r'),array('pipe','w'),array('pipe','w')),
        $pipes
    );
    $start = time();
    $stdout = '';
    $stderr = '';

    if(is_resource($process))
    {
        stream_set_blocking($pipes[0], 0);
        stream_set_blocking($pipes[1], 0);
        stream_set_blocking($pipes[2], 0);
        fwrite($pipes[0], $stdin);
        fclose($pipes[0]);
    }

    while(is_resource($process))
    {
        //echo ".";
        $stdout .= stream_get_contents($pipes[1]);
        $stderr .= stream_get_contents($pipes[2]);

        if($timeout !== false && time() - $start > $timeout)
        {
            proc_terminate($process, 9);
            return 1;
        }

        $status = proc_get_status($process);
        if(!$status['running'])
        {
            fclose($pipes[1]);
            fclose($pipes[2]);
            proc_close($process);
            return $status['exitcode'];
        }

        usleep(1000000);
    }

    return 1;
}
// Main code
$rs = DB::Query(
"SELECT id_task, title, date_init, date_next, date_end, status, 
increment_minutes, increment_hours, increment_days, increment_months, 
command, max_time_minutes
FROM scheduler_task where status = 0 and date_next <= now()"
);
while( $data = $rs->fetchAssoc() )
{
custom_error(10,"Id Task scheduler: ".$data['id_task']); // To debug

// Insert record of Execution
$data2 = array();
$data2["date_init"] = now();
$data2["scheduler_task_id"] = $data['id_task'];
DB::Insert("scheduler_task_execution", $data2 );
// get the ID of the inserted record 
$scheduler_task_execution = DB::LastId();

// Plan next execution
$data3 = array();
$keyvalues3 = array();

// $time = new DateTime($data['date_next']);
$time = new DateTime();
// $interval = new DateInterval('P2Y4DT6H8M');
$time->add(new DateInterval('P'.
				$data['increment_months'].'M'.
				$data['increment_days'].'D'.
				'T'.
				$data['increment_hours'].'H'.
				$data['increment_minutes'].'M'));
$stamp = $time->format('Y-m-d H:i');

$data3['date_next'] = $stamp;
if ( $data['date_end'] < $stamp ) { // Ha traspasado fecha de fin
	$data3['status'] = 1;
}
$keyvalues3['id_task'] = $data['id_task'];
DB::Update("scheduler_task", $data3, $keyvalues3 );


// Launch independent process
//  $dir_path_base = __DIR__;  // In process father
$command = str_replace("{DIR}", $dir_path_base, $data['command']);
$command = str_replace("{ID_TASK}", $scheduler_task_execution, $command);

custom_error(11,"Execute Command: ".$command ); // To debug

$max_time = $data['max_time_minutes']*60;
execute($command, null, $out, $err, $max_time);

// $result = shell_exec($command);
// $result = exec($command);

custom_error(12,"Execute Command -Result: ".$out ); // To debug
custom_error(13,"Execute Command -Error: ".$err ); // To debug

/*
// Update "Execution"
$data2 = array();
$keyvalues2 = array();
$data2["date_end"] = now();
$data2["result"]  = $result;
$keyvalues2["id_task_execution"] = $scheduler_task_execution;
DB::Update("scheduler_task_execution", $data2, $keyvalues2 );
*/

}    