<?php
// @ini_set("display_errors","1");
// require_once("include/dbcommon.php");

require_once(__DIR__.'/unirest_3.0.4/autoload.php');

/*
Criterio general que se utiliza en este ejemplo de actualización.
- En caso de que exista el artículo, se elimina y se crea uno nuevo
- Los ficheros de imágenes no se eliminan, siempre se crea la imagen para el nuevo artículo.

*/

$record_update = $_SESSION['record_update'];
foreach ($record_update as &$row) {
    $rs = DB::Query("SELECT * FROM drupal_articulo WHERE id_drupal_articulo = $row");
    $data_row = $rs->fetchAssoc();
    if ( $data_row['nid_articulo'] <> Null ) { // Existe Article en Drupal
       $result1_arr = delete_node($data_row['nid_articulo']); // Eliminar Node de Drupal
    }
    if ( $data_row['fid_imagen'] <> Null ) { // Existe File en Drupal
       $result1_arr = delete_file_drupal($data_row['fid_imagen']); // Eliminar File de Drupal
    }
    $json_file = '';
    if ($data_row['imagen'] <> '' ) { // Hay fichero para cargar
         $fileArray = my_json_decode($data_row['imagen']);
         $path_file = __DIR__.'/../'.$fileArray[0]['name'];
         $name_file = $fileArray[0]['usrName'];

         $result2_arr = upload_file_drupal($name_file,$path_file); // Subir fichero
         if ($result2_arr['code'] == 201 ) { // Imagen sibida a Drupal
             $data_file = json_decode($result2_arr['raw_body'], true);
             $fid = $data_file['fid'][0]['value'];
             $title = $data_file['filename'][0]['value'];
             $uuid = $data_file['uuid'][0]['value'];
             $url = $data_file['uri'][0]['url'];

$json_file = <<<EOT
"field_image": [{
 "target_id": $fid,
 "alt": "$title",
 "title": "$title",
 "target_type": "file",
 "target_uuid": "$uuid",
 "url": "$url"
}],
EOT;              
         }
     }
     $title = $data_row['titulo'];
     $body =   addslashes($data_row['cuerpo']);
     $body = preg_replace("/[\r\n|\n|\r]+/", " ", $body);  // Elimna saltos de línea
     $json_tag = '';
     if ( $data_row['etiquetas']<> '' ){ // Hay Tags definidas
         $json_tag = '"field_tags": [';
         $tags_arr = explode(",", $data_row['etiquetas']);
         for ($i = 0; $i < count($tags_arr); $i++) {
             if ($i > 0 ) { $json_tag .= ','; }
             $json_tag .= '{"target_id": "'.$tags_arr[$i].'", "target_type": "taxonomy_term"}';
         }
         $json_tag .='],';
     }

$json_article = <<<EOT
{
$json_file
$json_tag
"title": [{"value": "$title"}],
"body": [{
"value": "$body",
"format": "basic_html"
}],
"type": [{"target_id": "article"}]}
EOT;
    // Crear Artículo en Drupal
    $result3_arr = create_node($json_article);
    if ( $result3_arr['code'] == 201 ) { // Artículo creado
        $row_d = json_decode($result3_arr['raw_body'], true);

        // Update the record with id=50 in the 'Cars' table

        $data = array();
        $keyvalues = array();
        $data["nid_articulo"] = $row_d['nid'][0]['value'];
        if ( isset($row_d['field_image'][0]['target_id'])) { // Existe imagen?
            $data["fid_imagen"]  = $row_d['field_image'][0]['target_id'];
        }
        $keyvalues["id_drupal_articulo"] = $row;
        DB::Update("drupal_articulo", $data, $keyvalues );
    }


 }







// Recuperar todos los  datos de un Artículo de Drupal
 function read_node($id_node){
    include __DIR__."/config_drupal.php";
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
    $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::get($path_url.$path_access_node.$id_node, $headers, $query);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body; 
   
   custom_error(1011,"Read Node, respose Code: ".$return_arr['code'] ); // To debug
   
   return($return_arr); 
 }

// Eliminar un Artículo de Drupal
 function delete_node($id_node){
   include __DIR__."/config_drupal.php";
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
    // $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::delete($path_url . $path_access_node . $id_node .'?_format=json', $headers);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body; 
   
   custom_error(1012,"Delete Node, respose Code: ".$return_arr['code'] ); // To debug
    
   return($return_arr); 
 }

 // Crear un Artículo de Drupal
 function create_node($json){
    include __DIR__."/config_drupal.php";
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
     // $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::post($path_url . $path_access_node . '?_format=json', $headers, $json);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body;
   
    custom_error(1013,"Create Node, respose Code: ".$return_arr['code'] ); // To debug
   
   return($return_arr); 
 }

// Actualización de un Artículo de Drupal
 function update_node($id_node, $json){
    include __DIR__."/config_drupal.php";
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
     // $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::patch($path_url.$path_access_node.$id_node.'?_format=json', $headers, $json);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body; 
   
   custom_error(1014,"Update Node, respose Code: ".$return_arr['code'] ); // To debug
   
   return($return_arr); 
 }
 
 // Recuperar todos los datos de un fichero
 function read_file_drupal($id_file){
    include __DIR__."/config_drupal.php";
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
    $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::get($path_url.$path_access_file.$id_file, $headers, $query);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body;
   
   custom_error(1015,"Read File Drupal, respose Code: ".$return_arr['code'] ); // To debug
   
   return($return_arr); 
 }
 // ELIMINAR un fichero
 function delete_file_drupal($id_file){
    include __DIR__."/config_drupal.php";
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
    // $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::delete($path_url . $path_access_file . $id_file, $headers);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body; 
   
   custom_error(1016,"Delete File Drupal, respose Code: ".$return_arr['code'] ); // To debug
   return($return_arr); 
 }
 
  // upload un fichero a DRUPAL
 function upload_file_drupal($name_file,$path_file) {
    include __DIR__."/config_drupal.php";
    
    $headers = array(
        'Content-Type' => 'application/octet-stream',
        'Content-Disposition' => 'file; filename="'.$name_file.'"',
        'X-CSRF-Token' => $x_csrf_token );
    
    $filename = $path_file;
    $handle = fopen($filename, "r");
    $body = fread($handle, filesize($filename));
    fclose($handle);
    
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::post($path_url . $path_upload_file , $headers, $body);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body; 
   
   custom_error(1017,"Upload File Drupal, respose Code: ".$return_arr['code'] ); // To debug
   
   return($return_arr); 

 }
 
