<?php
// @ini_set("display_errors","1");
// require_once("include/dbcommon.php");

require_once(__DIR__.'/unirest_3.0.4/autoload.php');

$read_drupal = read_all_record();
if ($read_drupal['code'] == '200' ){ // Tratamiento de Artículos recibidos
    $data_arr = json_decode($read_drupal['raw_body'], true);
    foreach ($data_arr as &$row) {
        // Insert a record into the 'drupal_articulo' table 
        // SELECT d.`titulo`, d.`cuerpo`, d.`etiquetas`, d.`nid_articulo`, d.`fid_imagen`, d.`fecha_ultima_modificacion`, d.`imagen` FROM drupal_articulo d;
	$file = access_file_remote($row['field_image'][0]['url']);
        $filejson = '';
        if ( $file[0] == 0 ) { // Hay un fichero asociado al Artículo
            $id_file = $row['field_image'][0]['target_id'];
            $data_file = read_file_drupal($id_file);
            if ($data_file['code'] == 200){ // Se han recuperado los datos del fichero
                $row_f = json_decode($data_file['raw_body'], true);
                $usrName = $row_f['filename'][0]['value'];
                $size = $row_f['filesize'][0]['value'];
                $type = $row_f['filemime'][0]['value'];
                $searchStr = $row_f['filename'][0]['value'];
                $random = '_'.bin2hex(random_bytes(5));
                $file_arr = explode(".", $usrName);
/*
                $file_name_arr = explode("_", $file_arr[0]);
                $count = count($file_name_arr);
                if ( !( $count > 1 || strlen($file_name_arr[$count-1]) > 7 ) ) // Para que no crezca el nombre en las cargas anidadas
                { 
                    $random = ''; 
                }
*/
                $name = 'files/'.$file_arr[0].$random.'.'.$file_arr[1];
                $file_w = fopen(__DIR__."/../".$name, 'w+');
                fwrite($file_w, $file[1]);
                fclose($file_w);

                $filejson = <<<EOT
 [
	{
		"name": "$name",
		"usrName": "$usrName",
		"size": "$size",
		"type": "$type",
		"searchStr": "$usrName,!:sStrEnd"
	}
]
EOT;
                }
         
        }
        $data = array();
        $data["titulo"] = $row['title'][0]['value'];
        $data["cuerpo"]  = $row['body'][0]['value'];
        $data["etiquetas"] = $row['field_tags'][0]['target_id'];
        $data["nid_articulo"] = $row['nid'][0]['value'];
        $data["fid_imagen"] = $row['field_image'][0]['target_id'];
        $data["imagen"] = $filejson;
        
        DB::Insert("drupal_articulo", $data );     
    }
    
 }

 
// To access file in other server
function access_file_remote($url){ // 
 $ch = curl_init();
 curl_setopt($ch, CURLOPT_URL, $url);
 curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
 curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

 $file = curl_exec($ch);
 if($file === FALSE) {
		custom_error(1,"Access file: ".$url.' Error CURL: '.curl_error($ch)); // To debug
		$error = 1;
 } else {
		$error = 0;
 }
 curl_close($ch);
 $return_arr = array();
 $return_arr[0] = $error;
 $return_arr[1] = $file;
 return($return_arr);
} 
 
// Recuperar todos los Artículos de Drupal
 function read_all_record(){
    require(__DIR__."/config_drupal.php");
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
    $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::get($path_url.$path_access_list, $headers, $query);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body;

   custom_error(1001,"Read All Record, respose Code: ".$return_arr['code'] ); // To debug
 
   return($return_arr); 
 }
 
 // Recuperar todos los datos de un fichero
 function read_file_drupal($id_file){
    require(__DIR__."/config_drupal.php");
    
    $headers = array('Content-Type' => $content_type,'X-CSRF-Token' => $x_csrf_token );
    $query = array('_format' => 'json');
    // basic auth
    Unirest\Request::auth($user_drupal, $password_drupal);

    $response = Unirest\Request::get($path_url.$path_access_file.$id_file, $headers, $query);
    // $response->code;        // HTTP Status code
    // $response->headers;     // Headers
    // $response->body;        // Parsed body
    // $response->raw_body;    // Unparsed body 
   $return_arr = array();
   $return_arr['code'] = $response->code;
   $return_arr['raw_body'] = $response->raw_body; 

   custom_error(1002,"Read File Drupal, respose Code: ".$return_arr['code'] ); // To debug

   return($return_arr); 
 }
 

