<?php

$menu_arr = $_SESSION['menu_especial'];
$items_arr = array();

foreach ($menu_arr as &$row) {
    switch ($row['type']) {
    case 'E': // Externo
        $name = $row['name'];
        $url = $row['url'];
        $parent = $row['parent'];
        if ($parent > 0) {
            $parent = $items_arr[$parent]->id ; // Conversión de referencias
        }
        $item = $menu->addURL( $name, $url, $parent );
        $items_arr[$row['id']] = $item;   // para conversión referencias
        break;
    case 'G': // Grupo
        $name = $row['name'];
        $parent = $row['parent'];
        if ($parent > 0) {
            $parent = $items_arr[$parent]->id ; // Conversión de referencias
        }
        $item = $menu->addGroup( $name, $parent );
        $items_arr[$row['id']] = $item;   // para conversión referencias
        break;
    case 'T': // Tabla
        $name = $row['name'];
        $table = $row['table'];
        $page  = $row['page'];
        $params = $row['params'];
        $parent = $row['parent'];
        if ($parent > 0) {
            $parent = $items_arr[$parent]->id ; // Conversión de referencias
        }
        $item = $menu->addPageLink( $name, $table, $page, $parent);
        $item->setParams($params);
        $items_arr[$row['id']] = $item;   // para conversión referencias
        break;
    }
}

