$(() => {
  $('#persons').dxDataGrid({
    dataSource: persons,
    keyExpr: 'id_jsgrid_person',
    headerFilter: {
      visible: true
    },
    paging: {
      pageSize: 5
    },
    pager: {
      showPageSizeSelector: true,
      allowedPageSizes: [2,5, 10, 20, 'all'],
    },
    searchPanel: {
      visible: true,
      width: 240,
      placeholder: 'Search...'
    },
    /*
     filterRow: {
      visible: true,
      applyFilter: 'auto',
    },
     */
    selection: {
      mode: 'single',
    },
    columns: [
     {dataField: 'firtName',
      caption: 'Firt Name',
      headerFilter: {
        search: {
          enabled: true,
          editorOptions: {
            placeholder: 'Search by First Name',
          },
          searchExpr: ['firtName'],
        },
      },        
     },
     {dataField: 'lastName',
      caption: 'Last Name',
      headerFilter: {
        search: {
          enabled: true,
          editorOptions: {
            placeholder: 'Search by Last Name',
          },
          searchExpr: ['lastName'],
        },
      },        
     },
     {
      dataField: 'jsgrid_position_id',
      caption: 'Position',
      headerFilter: {
        allowSelectAll: false,
        search: {
          enabled: true,
        },
      },
      lookup: {
          dataSource: positions,
          displayExpr: 'title',
          valueExpr: 'id_jsgrid_position',
        },
     },
     {
      dataField: 'birthDate',
      caption: 'Birth Date',
      dataType: 'date',
      headerFilter: {
        allowSelectAll: false,
        search: {
          enabled: true,
        },
      },
    }, 
     {
      dataField: 'hireDate',
      caption: 'Hire Date',
      dataType: 'date',
      headerFilter: {
        allowSelectAll: false,
        search: {
          enabled: true,
        },
      },
    },          
    ],
    columnAutoWidth: true,
    showRowLines: true,
    showBorders: true,
    
    onSelectionChanged(selectedItems) {
      const data = selectedItems.selectedRowsData[0];
      if (data) {
        $('.employeePhoto').attr('src', data.picture);
        $('.detailNotes').html(data.capacities);
        var name = data.firtName+' '+data.lastName;
        $('.detailName').text(name); 
        const options = { 
            minimumFractionDigits: 2,
            maximumFractionDigits: 2 
          };
        const salary = Number(data.annualSalary).toLocaleString('es', options);
        $('.salary').text(salary);
        $('.titleSalary').text("Salary"); 
      }
    },
    
  });
  DevExpress.localization.locale(navigator.language);
});

