

$(() => {
  $('#municipios').dxDataGrid({
    dataSource: municipios,
    keyExpr: 'id',
    headerFilter: {
      visible: true
    },
    paging: {
      pageSize: 5
    },
    pager: {
      showPageSizeSelector: true,
      allowedPageSizes: [5, 10, 20, 50, 100, 1000, 'all'],
    },
    searchPanel: {
      visible: true,
      width: 240,
      placeholder: 'Buscar...'
    },
    /*
     filterRow: {
      visible: true,
      applyFilter: 'auto',
    },
     */
    selection: {
      mode: 'single',
    },
 
    columns: [
     {dataField: 'NombreProvincia',
      caption: 'Provincia',
      headerFilter: {
        search: {
          enabled: true,
          editorOptions: {
            placeholder: 'Búsqueda por Provincia',
          },
          searchExpr: ['NombreProvincia'],
        },
      },        
     },
     {dataField: 'NombreMunicipio',
      caption: 'Municipio',
      headerFilter: {
        search: {
          enabled: true,
          editorOptions: {
            placeholder: 'Búsqueda Nombre Prov.',
          },
          searchExpr: ['NombreMunicipio'],
        },
      },        
     }, 
     {
      dataField: 'CodigoProvincia',
      caption: 'Código Provincia',
      headerFilter: {
        search: {
          enabled: true,
          editorOptions: {
            placeholder: 'Búsqueda Cód. Provincia',
          },
          searchExpr: ['CodigoProvincia'],
        },
      },
    }, 
    {dataField: 'CodigoMunicipio',
     caption: "Código Municipio"
    }],
    export: {
      enabled: true,
    },
    onExporting(e) {
      const workbook = new ExcelJS.Workbook();
      const worksheet = workbook.addWorksheet('Municipios');

      DevExpress.excelExporter.exportDataGrid({
        component: e.component,
        worksheet,
        autoFilterEnabled: true,
        topLeftCell: { row: 3, column: 1 },
      }).then((cellRange) => {
        // header
        const headerRow = worksheet.getRow(1);
        headerRow.height = 30;
        worksheet.mergeCells(1, 1, 1, 4);

        headerRow.getCell(1).value = 'Provincias y Municipios de España';
        headerRow.getCell(1).font = { name: 'Segoe UI Light', size: 22 };
        headerRow.getCell(1).alignment = { horizontal: 'center' };

        // footer
        const footerRowIndex = cellRange.to.row + 2;
        const footerRow = worksheet.getRow(footerRowIndex);
        worksheet.mergeCells(footerRowIndex, 1, footerRowIndex, 4);

        footerRow.getCell(1).value = 'fhumanes.com';
        footerRow.getCell(1).font = { color: { argb: 'AA0910' }, italic: true };
        footerRow.getCell(1).alignment = { horizontal: 'left' };
      }).then(() => {
        workbook.xlsx.writeBuffer().then((buffer) => {
          saveAs(new Blob([buffer], { type: 'application/octet-stream' }), 'Municipios.xlsx');
        });
      });
    },
    columnAutoWidth: true,
    showRowLines: true,
    showBorders: true,
    /*
    onSelectionChanged(selectedItems) {
      const data = selectedItems.selectedRowsData[0];
      if (data) {
        $('.detailNotes').text(data.NombreProvincia);
        $('.detailKey').text(data.NombreMunicipio); 
      }
    },
     */
    
  });
  DevExpress.localization.locale(navigator.language);
});

