$(() => {
  const URL = 'http://localhost/devextreme_php/restapi/v1';

  /*
   ---------     Para formatear los valores numéricos  -----------------
  */

  function number_format(number, decimals, dec_point, thousands_sep) {
      //   example 1: number_format(1234.56);
      //   returns 1: '1,235'
      //   example 2: number_format(1234.56, 2, ',', ' ');
      //   returns 2: '1 234,56'
      //   example 3: number_format(1234.5678, 2, '.', '');
      //   returns 3: '1234.57'
      //   example 4: number_format(67, 2, ',', '.');
      //   returns 4: '67,00'
      //   example 5: number_format(1000);
      //   returns 5: '1,000'
      //   example 6: number_format(67.311, 2);
      //   returns 6: '67.31'
      //   example 7: number_format(1000.55, 1);
      //   returns 7: '1,000.6'
      //   example 8: number_format(67000, 5, ',', '.');
      //   returns 8: '67.000,00000'
      //   example 9: number_format(0.9, 0);
      //   returns 9: '1'
      //  example 10: number_format('1.20', 2);
      //  returns 10: '1.20'
      //  example 11: number_format('1.20', 4);
      //  returns 11: '1.2000'
      //  example 12: number_format('1.2000', 3);
      //  returns 12: '1.200'
      //  example 13: number_format('1 000,50', 2, '.', ' ');
      //  returns 13: '100 050.00'
      //  example 14: number_format(1e-8, 8, '.', '');
      //  returns 14: '0.00000001'
    
      number = (number + '')
        .replace(/[^0-9+\-Ee.]/g, '');
      var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function(n, prec) {
          var k = Math.pow(10, prec);
          return '' + (Math.round(n * k) / k)
            .toFixed(prec);
        };
      // Fix for IE parseFloat(0.55).toFixed(0) = 0;
      s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
        .split('.');
      if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
      }
      if ((s[1] || '')
        .length < prec) {
        s[1] = s[1] || '';
        s[1] += new Array(prec - s[1].length + 1)
          .join('0');
      }
      return s.join(dec);
    }

  /*
   ---------     Para las comunicaciones con el servidor PHP  -----------------
  */

    function sendRequest(url, method = 'GET', data) {
      const d = $.Deferred();
  
      $.ajax(url, {
        method,
        data,
        cache: false,
        xhrFields: { withCredentials: true },
      }).then((result) => {
        d.resolve(method === 'GET' ? result.data : result);
      }, (xhr) => {
        d.reject(xhr.responseJSON ? xhr.responseJSON.Message : xhr.statusText);
      });
  
      return d.promise();
    }
  /*
   ---------     Para las controlar las acciones y comunicarlas al server PHP  -----------------
  */

    function saveChange(url, change) {
      const msg = JSON.stringify(change.data);
      const key = change.key;

      switch (change.type) {
        case 'insert':
          return sendRequest(`${url}/orders/add/0`, 'POST', { values: JSON.stringify(change.data) });
        case 'update':
          return sendRequest(`${url}/orders/update/${change.key}`, 'POST', {  key: change.key, values: JSON.stringify(change.data) });
        case 'remove':
          return sendRequest(`${url}/orders/delete/${change.key}`, 'POST', { key: change.key });
        default:
          return null;
      }
    }
  /*
   ---------     Para las volver a cargar los datos de la PivotGrid  -----------------
  */
    function onDataGridSaved(e) {
      let pivotGridDS = pivotGrid.getDataSource();
      pivotGridDS.reload();
  }
   
    const loadPanel = $('#loadPanel').dxLoadPanel({
      position: {
        of: '#pivotgrid',
      },
      visible: false,
    }).dxLoadPanel('instance');
  
    /*
    loadPanel.show();
    sendRequest(`${URL}/orders/list`)
      .always(() => { loadPanel.hide(); })
      .then((data) => {
        pivotGrid.option('dataSource', data);
      });
   
*/
    const pivotGrid = $('#pivotgrid').dxPivotGrid({
      allowSorting: true,
      allowSortingBySummary: true,
      allowFiltering: true,
      // height: 620,
      showBorders: true,
      rowHeaderLayout: 'tree',
      scrolling: {
        mode: 'virtual',
      },


      // showColumnGrandTotals: true,
      // showRowGrandTotals: true,
      // showRowTotals: true,
      // showColumnTotals:true,


      allowExpandAll: true,
      // allowFiltering: true,
      // allowSorting: true,
      fieldPanel: {visible: true},


      height: '550px',
      width: '100%' ,
      encodeHtml: false,
      
      fieldChooser: {
        enabled: true,
        // allowSearch: true,
        height: 600,
        title: "Selector campos"
      },
      onCellClick(e) {
        if (e.area === 'data') {
          const pivotGridDataSource = e.component.getDataSource();
          const rowPathLength = e.cell.rowPath.length;
          const rowPathName = e.cell.rowPath[rowPathLength - 1];
          const popupTitle = `${rowPathName || 'Total'} Drill Down Data`;
  
          drillDownDataSource = pivotGridDataSource.createDrillDownDataSource(e.cell);
          ordersPopup.option('title', popupTitle);
          ordersPopup.show();
        }
      },

      //`OrderID`, `CustomerID`, `OrderDate`, `ShippedDate`, `Freight`, 
      //`ShipCity`, `ShipCountry`, `TotalOrder`
   
      dataSource: {
     
          remoteOperations: false,
          store: DevExpress.data.AspNet.createStore({
            key: 'OrderID',
            loadUrl: `${URL}/orders/list`,
         }),
  
            
        fields: [{
        dataField: 'OrderID',
        caption: 'ID',
        width: 8,
       
      }, {
        dataField: 'CustomerID',
        caption: 'Customer',
        width: 16,
        area: 'row',
      }, {
        dataField: 'ShipCountry',
        caption: 'Country',
        width: 15,
      }, {
        dataField: 'ShipCity',
        caption: 'City',
        width: 15,
      }, {
        dataField: 'ShippedDate',
        caption: 'Ship Date',
        dataType: 'date',
        //format: "date",
        // displayFormat: 'dd/mm/yyyy',
       //  value: date,
        
      },
      { groupName: "Date", groupInterval: "year", groupIndex: 0 },   
			{ groupName: "Date", groupInterval: "day", groupIndex: 1, format: "dd/MM/yyyy", 
        selector: function(data) {
          // var month = new Date(data.date).getMonth();
          return new Date(data.OrderDate);
      }} ,
      {
        dataField: 'OrderDate',
        caption: 'Order Date',
        dataType: 'date',
        groupName: "Date",
        // format: "dd/MM/yyyy",
        //format: "date",
    

        area: 'row',
      }, {
        dataField: 'Freight',
        caption: 'Freight',
        datatype: 'number',
        summaryType: 'sum',
        area: 'data',
        // alignment: 'right',
        format: function (value) {   
          formattedValue="<div  style=\" color: blue \">"
          +number_format(value,2,',','.') +"</div>";
          return formattedValue;
        },
       
      }, {
        dataField: 'TotalOrder',
        caption: 'Total Orden',
        datatype: 'nnumber',
        area: 'data',
        summaryType: 'sum',
        format: function (value) {
          value<0?formattedValue="<div  style=\" color: red \">"+number_format(value,2,',','.') +"</div>":
          formattedValue=value>0?number_format(value,2,',','.'):null;
          return formattedValue;
        },
      }
      ],
    },
 
     
      export: {
        enabled: true,
        fileName: "orders"
        },
        texts: {
            collapseAll: "Collapse All",
            dataNotAvailable: "N/A",
            expandAll: "Expand All",
            exportToExcel: "Exportar a fichero Excel",
            grandTotal: "Total General",
            noData: "No data",
            removeAllSorting: "Remove All Sorting",
            showFieldChooser: "Mostrar el selector de campos" ,
            sortColumnBySummary: "Sort {0} by This Column",
            sortRowBySummary: "Sort {0} by This Row",
            total: "{0} Total"
        },
  
    }).dxPivotGrid('instance');

    const ordersPopup = $('#pivotgrid-popup').dxPopup({
        width: 1000,
        height: 400,
        showCloseButton: true,
        showTitle: true,
        contentTemplate(contentElement) {
          $('<div />')
            .addClass('drill-down')
            .dxDataGrid({
              editing: {
                allowUpdating: true,
                // allowAdding: true,
                // allowDeleting: true,
               
              },
              width:950,
              height: 350,
             
              onSaving(e) {
                // console.log(e);

                const change = e.changes[0];
          
                if (change) {
                  e.cancel = true;
                  loadPanel.show();
                  e.promise = saveChange(URL, change)
                    .always(() => { loadPanel.hide(); })
                    .then((data) => {
                      
                      let orders = e.component.option('dataSource');
          
                      if (change.type === 'insert') {
                        change.data = data;
                      }
                    
                      //  data = DevExpress.data.applyChanges(data, [change], { keyExpr: 'OrderID' });
                     
                      e.component.option({
                        dataSource: data,
                        editing: {
                          editRowKey: null,
                          changes: [],
                        },
                      });
                      
                      // location.reload(); 
                      onDataGridSaved(e);
                      ordersPopup.hide();
                    }
                  );
                }
              },

              columns: [{
                dataField: 'OrderID',
                caption: 'ID',
                width: 8,
                allowEditing: false,
              }, {
                dataField: 'CustomerID',
                caption: 'Customer',
                allowEditing: false,
              }, {
                dataField: 'ShipCountry',
                allowEditing: false,
              }, {
                dataField: 'ShipCity',
                allowEditing: false,
              }, {
                dataField: 'ShippedDate',
                dataType: 'date',
                format: "shortDate",
                allowEditing: false,
              }, {
                dataField: 'OrderDate',
                dataType: 'date',
                format: "shortDate",
              }, {
                dataField: 'Freight',
                datatype: 'number',
                encodeHtml: false,
                alignment: 'right',
                format: function (value) {
                  
                  formattedValue="<div  style=\" color: blue \">"
                  +number_format(value,2,',','.') +"</div>";
                  return formattedValue;
                },
              }, {
                dataField: 'TotalOrder',
                caption: 'Total Orden',
                encodeHtml: false,
                alignment: 'right',
                datatype: 'number',
                format: function (value) {
                  value<0?formattedValue="<div  style=\" color: red \">"+number_format(value,2,',','.') +"</div>":
                  formattedValue=value>0?number_format(value,2,',','.'):null;
                  return formattedValue;
                }
              }
              ],
              

              // columns: ['banco','Fecha', 'Categoría', 'Subcategoria','Tipo', 'Importe','Descripcion'],

            })
            .appendTo(contentElement);
        },


        
        onShowing() {
          $('.drill-down')
            .dxDataGrid('instance')
            .option('dataSource', drillDownDataSource);
        },
        onShown() {
          $('.drill-down')
            .dxDataGrid('instance')
            .updateDimensions();
        },
        onRowUpdating: function(e) {
          console.log(e);
          data.update(e.key, e.newData); 
        
        },
        onRowInserting: function(e){
          data.insert(e.data);
          
        },      
       onRowRemoving: function(e){
           data.remove(e.key);
          
        },

        onSaving(e) {
          const change = e.changes[0];
    
          if (change) {
            e.cancel = true;
            loadPanel.show();
            e.promise = saveChange(URL, change)
              .always(() => { loadPanel.hide(); })
              .then((data) => {
                let orders = e.component.option('dataSource');
    
                if (change.type === 'insert') {
                  change.data = data;
                }
                orders = DevExpress.data.applyChanges(orders, [change], { keyExpr: 'OrderID' });
    
                e.component.option({
                  dataSource: orders,
                  editing: {
                    editRowKey: null,
                    changes: [],
                  },
                });
              });
          }
        },

      }).dxPopup('instance');

    DevExpress.localization.locale(navigator.language);
  });